'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Toggle;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                   */

function Toggle(_ref) {
  var onChange = _ref.onChange;
  var value = _ref.value;
  var values = _ref.values;

  return _react2.default.createElement(
    'div',
    { className: _style2.default.wrapper },
    (0, _lodash.map)(values, function (val, key) {
      return _react2.default.createElement(
        'button',
        {
          key: key,
          className: (0, _classnames2.default)(_style2.default.btn, _defineProperty({}, _style2.default.active, key === value)),
          onClick: function onClick() {
            return onChange(key);
          }
        },
        val
      );
    })
  );
}

Toggle.displayName = 'Toggle';

Toggle.propTypes = {
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.string.isRequired,
  values: _propTypes2.default.objectOf(_propTypes2.default.string).isRequired
};