'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _kualiUi = require('@kuali/kuali-ui');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _lodash = require('lodash');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var ColumnVisibility = function (_React$Component) {
  _inherits(ColumnVisibility, _React$Component);

  function ColumnVisibility(props) {
    _classCallCheck(this, ColumnVisibility);

    var _this = _possibleConstructorReturn(this, (ColumnVisibility.__proto__ || Object.getPrototypeOf(ColumnVisibility)).call(this, props));

    _this.handleChange = function (checked, evt) {
      var column = evt.target.name;
      var hiddenColumns = _this.state.hiddenColumns;


      if ((0, _lodash.includes)(hiddenColumns, column) && checked) {
        hiddenColumns = hiddenColumns.filter(function (name) {
          return name !== column;
        });
      } else if (!checked) {
        hiddenColumns = [].concat(_toConsumableArray(hiddenColumns), [column]);
      }

      _this.setState({ hiddenColumns: hiddenColumns });
      _this.props.onChange(hiddenColumns);
    };

    _this.state = {
      hiddenColumns: _this.props.initialHiddenColumns
    };
    return _this;
  }

  _createClass(ColumnVisibility, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var headers = this.props.headers;
      var hiddenColumns = this.state.hiddenColumns;


      return _react2.default.createElement(
        'div',
        null,
        headers.map(function (header, index) {
          var checked = !(0, _lodash.includes)(hiddenColumns, header.key);

          return _react2.default.createElement(_kualiUi.Checkbox, {
            key: header.key,
            id: header.key,
            name: header.key,
            label: header.label,
            checked: checked,
            onChange: _this2.handleChange
          });
        })
      );
    }
  }]);

  return ColumnVisibility;
}(_react2.default.Component);

ColumnVisibility.propTypes = {
  onChange: _propTypes2.default.func,
  headers: _propTypes2.default.array,
  initialHiddenColumns: _propTypes2.default.array
};
ColumnVisibility.defaultProps = {
  onChange: _lodash.noop,
  initialHiddenColumns: []
};
exports.default = ColumnVisibility;