'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setHiddenColumns = setHiddenColumns;
exports.getHiddenColumns = getHiddenColumns;
exports.setHiddenColumnsUpdateHandler = setHiddenColumnsUpdateHandler;
exports.getHiddenColumnsUpdateHandler = getHiddenColumnsUpdateHandler;

var _lodash = require('lodash');

function setHiddenColumns(formKey, context, value) {
  (0, _lodash.set)(context, ['lists', 'prefs', formKey, 'hiddenColumns'], value);
}

function getHiddenColumns(formKey, context) {
  return (0, _lodash.get)(context, ['lists', 'prefs', formKey, 'hiddenColumns'], []);
}

function setHiddenColumnsUpdateHandler(formKey, context, handler) {
  (0, _lodash.set)(context, ['lists', 'prefs', formKey, 'hiddenColumnsUpdateHandler'], handler);
}

function getHiddenColumnsUpdateHandler(formKey, context) {
  var defaultHandler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _lodash.noop;

  return (0, _lodash.get)(context, ['lists', 'prefs', formKey, 'hiddenColumnsUpdateHandler'], defaultHandler);
}