'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _kualiUi = require('@kuali/kuali-ui');

var _lodash = require('lodash');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var styles = {
  'filterDialog': 'filter-dialog__filterDialog___mQ2TN',
  'filterControlButton': 'filter-dialog__filterControlButton___1UwE_',
  'filterValues': 'filter-dialog__filterValues___2J7cT'
};

var FilterDialog = function (_React$Component) {
  _inherits(FilterDialog, _React$Component);

  function FilterDialog(props) {
    _classCallCheck(this, FilterDialog);

    var _this = _possibleConstructorReturn(this, (FilterDialog.__proto__ || Object.getPrototypeOf(FilterDialog)).call(this, props));

    _this.handleFilterValueChecked = function (colKey, checked, e) {
      var value = e.target.value;
      var hiddenValues = _this.props.hiddenValues;


      var newHidden = checked ? hiddenValues.filter(function (v) {
        return v !== value;
      }) // Remove the value from hidden
      : (0, _lodash.uniq)([].concat(_toConsumableArray(hiddenValues), [value])); // Add the value to hidden

      _this.props.updateHiddenValues(newHidden);
    };

    _this.handleFilterFindTextChanged = function (filterFindText) {
      _this.setState({
        filterFindText: filterFindText
      });
    };

    _this.handleSelectAllClicked = function () {
      _this.props.updateHiddenValues([]); // Don't hide any of them
    };

    _this.handleClearAllClicked = function (values, e) {
      _this.props.updateHiddenValues(values); // Hide all of the values
    };

    _this.state = {
      filterFindText: ''
    };
    return _this;
  }

  _createClass(FilterDialog, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          colKey = _props.colKey,
          hiddenValues = _props.hiddenValues,
          labelForValue = _props.labelForValue,
          rows = _props.rows;
      var filterFindText = this.state.filterFindText;
      // Get unique values for the dialog

      var values = (0, _lodash.uniq)(rows.map(function (row) {
        return row[colKey];
      }).filter(function (val) {
        return !(0, _lodash.isEmpty)(val) && ((0, _lodash.isEmpty)(filterFindText) || val.toLowerCase().indexOf(filterFindText.toLowerCase()) !== -1);
      })).sort();

      return _react2.default.createElement(
        'div',
        { className: styles.filterDialog, onClick: function onClick(e) {
            return e.stopPropagation();
          } },
        _react2.default.createElement(_kualiUi.TextField, {
          style: { marginBottom: '10px' },
          leftIcon: _react2.default.createElement(_kualiUi.Icon, { name: 'search' }),
          placeholder: 'Find',
          value: filterFindText,
          onChange: this.handleFilterFindTextChanged
        }),
        _react2.default.createElement(
          'div',
          { style: { display: 'flex', marginBottom: '10px' } },
          _react2.default.createElement(_kualiUi.FlatButton, {
            className: styles.filterControlButton,
            label: 'Select All',
            onClick: this.handleSelectAllClicked
          }),
          _react2.default.createElement(_kualiUi.FlatButton, {
            className: styles.filterControlButton,
            label: 'Clear All',
            onClick: (0, _lodash.partial)(this.handleClearAllClicked, values)
          })
        ),
        _react2.default.createElement(
          'div',
          { className: styles.filterValues },
          _react2.default.createElement(
            'div',
            null,
            values.map(function (value) {
              return _react2.default.createElement(_kualiUi.Checkbox, {
                id: 'filter-' + colKey + '-' + value,
                key: value,
                label: labelForValue(colKey, value),
                name: colKey,
                value: value,
                checked: !(0, _lodash.includes)(hiddenValues, value),
                onChange: (0, _lodash.partial)(_this2.handleFilterValueChecked, colKey)
              });
            }),
            (0, _lodash.isEmpty)(values) && _react2.default.createElement(
              'div',
              { style: { margin: '10px 0' } },
              'No values'
            )
          )
        )
      );
    }
  }]);

  return FilterDialog;
}(_react2.default.Component);

FilterDialog.propTypes = {
  colKey: _propTypes2.default.string,
  rows: _propTypes2.default.array,
  labelForValue: _propTypes2.default.func.isRequired,
  hiddenValues: _propTypes2.default.array,
  updateHiddenValues: _propTypes2.default.func
};
FilterDialog.defaultProps = {
  rows: [],
  colKey: '',
  hiddenValues: [],
  updateHiddenValues: _lodash.noop
};
exports.default = FilterDialog;