'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decomposeGadget = decomposeGadget;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function decomposeGadget(component, key) {
  var decomposed = {};
  var children = (0, _lodash.get)(component, 'props.children', []);
  _react2.default.Children.forEach(children, function (child) {
    if (!child) return;

    var props = child.props;

    var formKey = (0, _lodash.get)(props, 'formKey');
    if (formKey && formKey === key) {
      decomposed.gadget = child;
    } else if (child.type === 'label') {
      decomposed.label = child;
    } else {
      decomposed.desc = child;
    }
  });
  return decomposed;
}