'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _classnames3 = require('classnames');

var _classnames4 = _interopRequireDefault(_classnames3);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

// The basis for this component was this: https://github.com/chenglou/react-treeview

var styles = {
  'parentNode': 'style__parentNode___5Ojx2',
  'item': 'style__item___3q8E_',
  'children': 'style__children___HnbWs',
  'childrenCollapsed': 'style__childrenCollapsed___F3QaY',
  'nodeButton': 'style__nodeButton___2LaUV',
  'selected': 'style__selected___1mZtx',
  'treeView': 'style__treeView___3yUWj',
  'arrow': 'style__arrow___24eWt',
  'arrowCollapsed': 'style__arrowCollapsed___1xT0v'
};

var Node = function (_React$PureComponent) {
  _inherits(Node, _React$PureComponent);

  function Node() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, Node);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = Node.__proto__ || Object.getPrototypeOf(Node)).call.apply(_ref, [this].concat(args))), _this), _initialiseProps.call(_this), _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(Node, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          collapsed = _props.collapsed,
          nodeLabel = _props.nodeLabel,
          children = _props.children;


      var arrow = _react2.default.createElement(
        _kualiUi.IconButton,
        {
          'aria-label': 'Toggle Node Collapsed',
          onClick: this.handleArrowClick,
          className: (0, _classnames4.default)(styles.arrow, _defineProperty({}, styles.arrowCollapsed, collapsed))
        },
        _react2.default.createElement(_kualiUi.Icon, { name: 'arrow_drop_down' })
      );

      return _react2.default.createElement(
        'div',
        { className: styles.treeView },
        _react2.default.createElement(
          'div',
          { className: styles.item },
          arrow,
          nodeLabel
        ),
        _react2.default.createElement(
          'div',
          {
            className: (0, _classnames4.default)(styles.children, _defineProperty({}, styles.childrenCollapsed, collapsed))
          },
          children
        )
      );
    }
  }]);

  return Node;
}(_react2.default.PureComponent);

Node.propTypes = {
  collapsed: _propTypes2.default.bool,
  nodeLabel: _propTypes2.default.node.isRequired,
  onCollapseToggle: _propTypes2.default.func
};

var _initialiseProps = function _initialiseProps() {
  var _this2 = this;

  this.handleArrowClick = function () {
    if (_this2.props.onCollapseToggle) {
      var _props2;

      (_props2 = _this2.props).onCollapseToggle.apply(_props2, arguments);
    }
  };
};

exports.default = Node;