'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _classnames2 = require('classnames');

var _classnames3 = _interopRequireDefault(_classnames2);

var _node = require('./node');

var _node2 = _interopRequireDefault(_node);

var _nodeLabel = require('./node-label');

var _nodeLabel2 = _interopRequireDefault(_nodeLabel);

var _lodash = require('lodash');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var styles = {
  'parentNode': 'style__parentNode___5Ojx2',
  'item': 'style__item___3q8E_',
  'children': 'style__children___HnbWs',
  'childrenCollapsed': 'style__childrenCollapsed___F3QaY',
  'nodeButton': 'style__nodeButton___2LaUV',
  'selected': 'style__selected___1mZtx',
  'treeView': 'style__treeView___3yUWj',
  'arrow': 'style__arrow___24eWt',
  'arrowCollapsed': 'style__arrowCollapsed___1xT0v'
};

var Tree = function (_React$Component) {
  _inherits(Tree, _React$Component);

  function Tree(props) {
    _classCallCheck(this, Tree);

    var _this = _possibleConstructorReturn(this, (Tree.__proto__ || Object.getPrototypeOf(Tree)).call(this, props));

    _this.handleToggleNodeCollapse = function (toggleIndex, e) {
      if (_this.props.collapsible) {
        e.stopPropagation();
        var newNodesCollapsed = [].concat(_toConsumableArray(_this.state.nodesCollapsed));
        var collapsed = newNodesCollapsed[toggleIndex];
        newNodesCollapsed[toggleIndex] = !collapsed;
        _this.setState({
          nodesCollapsed: newNodesCollapsed
        });
      }
    };

    _this.handleToggleNodeSelected = function (nodeKey, e) {
      e.stopPropagation();
      var _this$props = _this.props,
          value = _this$props.value,
          readOnly = _this$props.readOnly,
          onChange = _this$props.onChange;

      if (!readOnly) {
        var newValue = [].concat(_toConsumableArray(value));
        var index = newValue.indexOf(nodeKey);
        if (index > -1) {
          newValue.splice(index, 1);
        } else {
          newValue.push(nodeKey);
        }
        onChange(newValue);
      }
    };

    _this.state = {
      nodesCollapsed: props.nodes.map(function (node) {
        return props.startCollapsed;
      })
    };
    return _this;
  }

  _createClass(Tree, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          className = _props.className,
          nodes = _props.nodes,
          value = _props.value,
          valueKey = _props.valueKey,
          labelKey = _props.labelKey,
          childKey = _props.childKey,
          parentIcon = _props.parentIcon,
          leafIcon = _props.leafIcon,
          readOnly = _props.readOnly,
          rest = _objectWithoutProperties(_props, ['className', 'nodes', 'value', 'valueKey', 'labelKey', 'childKey', 'parentIcon', 'leafIcon', 'readOnly']);

      var nodesCollapsed = this.state.nodesCollapsed;


      return _react2.default.createElement(
        'div',
        { className: className },
        nodes.map(function (node, i) {
          var nodeLabel = node[labelKey],
              nodeKey = node[valueKey],
              nodeChildren = node[childKey];

          var isSelected = value.includes(nodeKey);
          var selectedClass = isSelected ? styles.selected : '';
          var onNodeClick = (0, _lodash.partial)(_this2.handleToggleNodeSelected, nodeKey);

          return _react2.default.createElement(
            'div',
            {
              key: nodeKey,
              className: (0, _classnames3.default)(_defineProperty({}, styles.parentNode, !readOnly))
            },
            nodeChildren ? _react2.default.createElement(
              _node2.default,
              {
                nodeLabel: _react2.default.createElement(_nodeLabel2.default, {
                  label: nodeLabel,
                  iconName: parentIcon,
                  className: selectedClass,
                  onClick: onNodeClick
                }),
                collapsed: nodesCollapsed[i],
                onCollapseToggle: (0, _lodash.partial)(_this2.handleToggleNodeCollapse, i)
              },
              _react2.default.createElement(Tree, _extends({
                nodes: nodeChildren,
                value: value,
                parentIcon: parentIcon,
                leafIcon: leafIcon,
                readOnly: readOnly,
                labelKey: labelKey,
                valueKey: valueKey,
                childKey: childKey
              }, rest))
            ) : _react2.default.createElement(
              'div',
              { className: styles.item },
              _react2.default.createElement(_nodeLabel2.default, {
                label: nodeLabel,
                iconName: leafIcon,
                className: selectedClass,
                onClick: onNodeClick
              })
            )
          );
        })
      );
    }
  }]);

  return Tree;
}(_react2.default.Component);

Tree.propTypes = {
  className: _propTypes2.default.string,
  nodes: _propTypes2.default.array,
  value: _propTypes2.default.array,
  valueKey: _propTypes2.default.string,
  labelKey: _propTypes2.default.string,
  childKey: _propTypes2.default.string,
  collapsible: _propTypes2.default.bool,
  startCollapsed: _propTypes2.default.bool,
  parentIcon: _propTypes2.default.string,
  leafIcon: _propTypes2.default.string,
  readOnly: _propTypes2.default.bool
};
Tree.defaultProps = {
  nodes: [],
  value: [],
  labelKey: 'label',
  valueKey: 'key',
  childKey: 'children',
  collapsible: true,
  startCollapsed: false,
  parentIcon: 'folder',
  leafIcon: 'insert_drive_file',
  readOnly: false
};
exports.default = Tree;