'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compare = compare;

var _lodash = require('lodash');

function compare(a, b, sortAsc) {
  // Always put empty values at the bottom
  if ((0, _lodash.isEmpty)(a)) return 1;
  if ((0, _lodash.isEmpty)(b)) return -1;
  // Cast values to numbers if they can be
  if (!isNaN(a) && !isNaN(b)) {
    a = parseFloat(a);
    b = parseFloat(b);
  }
  if (a > b) return sortAsc ? 1 : -1;
  if (a < b) return sortAsc ? -1 : 1;
  return 0;
} /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
   * You may use and modify this code under the terms of the Kuali, Inc.
   * Pre-Release License Agreement. You may not distribute it.
   *
   * You should have received a copy of the Kuali, Inc. Pre-Release License
   * Agreement with this file. If not, please write to license@kuali.co.
   */