'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _lodash = require('lodash');

var _shortid = require('shortid');

var _shortid2 = _interopRequireDefault(_shortid);

var _reactDnd = require('react-dnd');

var _builder = require('./builder.css');

var _builder2 = _interopRequireDefault(_builder);

var _sectionDescriptor = require('../components/section-descriptor');

var _sectionDescriptor2 = _interopRequireDefault(_sectionDescriptor);

var _gadgetDescriptor = require('../components/gadget-descriptor');

var _gadgetDescriptor2 = _interopRequireDefault(_gadgetDescriptor);

var _addItem = require('../components/add-item');

var _addItem2 = _interopRequireDefault(_addItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var boxSource = {
  beginDrag: function beginDrag(props) {
    return {
      gadget: props.section || props.gadget,
      onMove: props.onMove
    };
  },
  isDragging: function isDragging(props, monitor) {
    if (props.isDragging) return true;
    var gadget = props.section || props.gadget;
    if (gadget === monitor.getItem().gadget) return true;
    return false;
  },
  endDrag: function endDrag(props, monitor) {
    if (!monitor.didDrop()) return;
    var item = monitor.getItem();
    var dropResult = monitor.getDropResult();
    if (dropResult) {
      if (item.gadget.id === (0, _lodash.get)(dropResult, 'target.id')) return;
      item.onMove(item.gadget, dropResult.target, dropResult.direction, dropResult.targetParent);
    }
  }
};

var boxTarget = {
  canDrop: function canDrop(props, monitor, component) {
    if (props.isDragging) return false;
    return true;
  },
  drop: function drop(props, monitor, component) {
    if (monitor.getDropResult()) return;

    var _monitor$getClientOff = monitor.getClientOffset(),
        y = _monitor$getClientOff.y;

    var _findDOMNode$getBound = (0, _reactDom.findDOMNode)(component).getBoundingClientRect(),
        top = _findDOMNode$getBound.top,
        height = _findDOMNode$getBound.height;

    var direction = y < top + height / 2 ? 0 : 1;
    return {
      target: props.section || props.gadget,
      targetParent: props.parentId,
      direction: direction
    };
  },
  hover: function hover(props, monitor, component) {
    if (!monitor.canDrop()) {
      return;
    }

    var rawComponent = undecorate(component);
    if (!rawComponent.setHovering) return;

    var _monitor$getClientOff2 = monitor.getClientOffset(),
        y = _monitor$getClientOff2.y;

    var _findDOMNode$getBound2 = (0, _reactDom.findDOMNode)(component).getBoundingClientRect(),
        top = _findDOMNode$getBound2.top,
        height = _findDOMNode$getBound2.height;

    if (y < top + height / 2) {
      rawComponent.setHovering('above');
    } else {
      rawComponent.setHovering('below');
    }
  }
};

function undecorate(component) {
  var curr = component;
  while (typeof curr.getDecoratedComponentInstance === 'function') {
    curr = curr.getDecoratedComponentInstance();
  }
  return curr;
}

var DropZone = function DropZone(props) {
  return _react2.default.createElement('div', { className: _builder2.default.dropzone });
};

var getDragNDropInterface = function getDragNDropInterface(Component) {
  return function (_React$Component) {
    _inherits(_DragNDropInterface, _React$Component);

    function _DragNDropInterface() {
      var _ref;

      var _temp, _this, _ret;

      _classCallCheck(this, _DragNDropInterface);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = _DragNDropInterface.__proto__ || Object.getPrototypeOf(_DragNDropInterface)).call.apply(_ref, [this].concat(args))), _this), _this.setHovering = (0, _lodash.throttle)(function (position) {
        _this.setState({ hovering: position });
      }, 100), _this.state = {
        hovering: null
      }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _createClass(_DragNDropInterface, [{
      key: 'render',
      value: function render() {
        var props = this.props;
        var hovering = this.state.hovering;


        return props.connectDragSource(props.connectDropTarget(_react2.default.createElement(
          'div',
          null,
          !props.isDragging && props.isOver && hovering === 'above' && props.connectDropTarget(_react2.default.createElement(
            'div',
            null,
            _react2.default.createElement(DropZone, null)
          )),
          _react2.default.createElement(Component, props),
          !props.isDragging && props.isOver && hovering === 'below' && props.connectDropTarget(_react2.default.createElement(
            'div',
            null,
            _react2.default.createElement(DropZone, null)
          ))
        )));
      }
    }]);

    return _DragNDropInterface;
  }(_react2.default.Component);
};

var RenderSection = (0, _reactDnd.DropTarget)('Gadget', boxTarget, function (connect, monitor) {
  return {
    connectDropTarget: connect.dropTarget(),
    isOver: monitor.isOver({ shallow: true })
  };
})((0, _reactDnd.DragSource)('Gadget', boxSource, function (connect, monitor) {
  return {
    connectDragSource: connect.dragSource(),
    isDragging: monitor.isDragging()
  };
})(getDragNDropInterface(_sectionDescriptor2.default)));

var RenderGadget = (0, _reactDnd.DropTarget)('Gadget', boxTarget, function (connect, monitor) {
  return {
    connectDropTarget: connect.dropTarget(),
    isOver: monitor.isOver({ shallow: true })
  };
})((0, _reactDnd.DragSource)('Gadget', boxSource, function (connect, monitor) {
  return {
    connectDragSource: connect.dragSource(),
    isDragging: monitor.isDragging()
  };
})(getDragNDropInterface(_gadgetDescriptor2.default)));

var SectionDropzone = (0, _reactDnd.DropTarget)('Gadget', boxTarget, function (connect, monitor) {
  return {
    connectDropTarget: connect.dropTarget(),
    isOver: monitor.isOver({ shallow: true })
  };
})(function (_React$Component2) {
  _inherits(SectionDropzone, _React$Component2);

  function SectionDropzone() {
    _classCallCheck(this, SectionDropzone);

    return _possibleConstructorReturn(this, (SectionDropzone.__proto__ || Object.getPrototypeOf(SectionDropzone)).apply(this, arguments));
  }

  _createClass(SectionDropzone, [{
    key: 'render',
    value: function render() {
      var _DropZone = !this.props.isDragging && this.props.isOver && _react2.default.createElement(DropZone, null);
      return this.props.connectDropTarget(_react2.default.createElement(
        'div',
        { style: { width: '100%' } },
        this.props.children(_DropZone)
      ));
    }
  }]);

  return SectionDropzone;
}(_react2.default.Component));

var Builder = function (_Component) {
  _inherits(Builder, _Component);

  function Builder() {
    var _ref2;

    var _temp2, _this3, _ret2;

    _classCallCheck(this, Builder);

    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return _ret2 = (_temp2 = (_this3 = _possibleConstructorReturn(this, (_ref2 = Builder.__proto__ || Object.getPrototypeOf(Builder)).call.apply(_ref2, [this].concat(args))), _this3), _this3.onAddGadgetToEmptyTemplate = function (gadget) {
      var initialTemplate = (0, _lodash.isFunction)((0, _lodash.get)(gadget, 'meta.initialTemplate')) ? gadget.meta.initialTemplate() : {};

      var newGadget = _extends({}, initialTemplate, {
        type: gadget.type,
        id: _shortid2.default.generate()
      });
      var template = _this3.props.template;

      if ((0, _lodash.isEmpty)(template)) {
        _this3.props.onChange({
          id: _shortid2.default.generate(),
          children: [newGadget]
        });
      } else {
        var newChildren = [].concat(_toConsumableArray(template.children), [newGadget]);
        _this3.props.onChange(template.id, _extends({}, template, {
          children: newChildren
        }));
      }

      _this3.props.onClickSettings(newGadget.id);
    }, _temp2), _possibleConstructorReturn(_this3, _ret2);
  }

  _createClass(Builder, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          template = _props.template,
          gadgets = _props.gadgets,
          onChange = _props.onChange,
          onClickSettings = _props.onClickSettings,
          onMove = _props.onMove,
          onDelete = _props.onDelete;

      return _react2.default.createElement(
        'div',
        { className: _builder2.default.form },
        (0, _lodash.map)(template.children, function (child) {
          if (child.children) {
            return _react2.default.createElement(RenderSection, {
              key: child.id,
              section: child,
              onChange: onChange,
              onDelete: onDelete,
              gadgets: gadgets,
              onMove: onMove,
              SectionRenderer: RenderSection,
              GadgetRenderer: RenderGadget,
              onClickSettings: onClickSettings,
              parentId: template.id,
              SectionDropzone: SectionDropzone
            });
          }
          return _react2.default.createElement(RenderGadget, {
            key: child.id,
            gadget: child,
            gadgets: gadgets,
            onClickSettings: onClickSettings,
            onDelete: onDelete,
            onMove: onMove,
            parentId: template.id
          });
        }),
        _react2.default.createElement(
          'div',
          { style: { display: 'flex' } },
          _react2.default.createElement(_addItem2.default, {
            gadgets: gadgets,
            onGadgetSelection: this.onAddGadgetToEmptyTemplate
          })
        )
      );
    }
  }]);

  return Builder;
}(_react.Component);

exports.default = Builder;