'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _lodash = require('lodash');

var _kualiUi = require('@kuali/kuali-ui');

var _Buttons = require('react-md/lib/Buttons');

var _Buttons2 = _interopRequireDefault(_Buttons);

var _generalSettings = require('./general-settings.css');

var _generalSettings2 = _interopRequireDefault(_generalSettings);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var ProgressiveDisclosureConfigure = function (_Component) {
  _inherits(ProgressiveDisclosureConfigure, _Component);

  function ProgressiveDisclosureConfigure() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, ProgressiveDisclosureConfigure);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = ProgressiveDisclosureConfigure.__proto__ || Object.getPrototypeOf(ProgressiveDisclosureConfigure)).call.apply(_ref, [this].concat(args))), _this), _this.handleRemovePdPart = function (i) {
      var _this$props = _this.props,
          value = _this$props.value,
          onChange = _this$props.onChange;

      var type = (0, _lodash.get)(value, 'progressiveDisclosure.type') || 'any';
      var parts = (0, _lodash.get)(value, 'progressiveDisclosure.parts') || [];
      parts = [].concat(_toConsumableArray(parts));
      parts.splice(i, 1);
      var newVal = { type: type, parts: parts };
      if (!parts.length) newVal = null;
      onChange('progressiveDisclosure', newVal);
    }, _this.handleAddPdPart = function () {
      var _this$props2 = _this.props,
          value = _this$props2.value,
          onChange = _this$props2.onChange;

      var type = (0, _lodash.get)(value, 'progressiveDisclosure.type') || 'any';
      var parts = (0, _lodash.get)(value, 'progressiveDisclosure.parts') || [];
      var newVal = {
        type: type,
        parts: [].concat(_toConsumableArray(parts), [{ formKey: '', data: {} }])
      };
      onChange('progressiveDisclosure', newVal);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(ProgressiveDisclosureConfigure, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          progressiveDisclosures = _props.progressiveDisclosures,
          _onChange = _props.onChange,
          value = _props.value,
          validating = _props.validating;

      var pdParts = (0, _lodash.get)(value, 'progressiveDisclosure.parts') || [];
      var progressiveDisclosuresByParent = (0, _lodash.reduce)(progressiveDisclosures, function (memo, pd) {
        if (!pd.parent) {
          memo.__no_parent.children.push(pd);
        } else {
          memo[pd.parent.id] = memo[pd.parent.id] || {
            id: pd.parent.id,
            label: pd.parent.label,
            children: []
          };
          memo[pd.parent.id].children.push(pd);
        }
        return memo;
      }, { __no_parent: { label: '', children: [] } });
      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'div',
          { style: { paddingTop: 15 } },
          pdParts.length >= 2 && _react2.default.createElement(
            'div',
            { className: _generalSettings2.default.anyOrAll },
            _react2.default.createElement(_kualiUi.SelectField, {
              className: _generalSettings2.default.select,
              onChange: function onChange(val) {
                return _onChange('progressiveDisclosure.type', val);
              },
              value: (0, _lodash.get)(value, 'progressiveDisclosure.type'),
              menuItems: [{ value: 'any', label: 'Any' }, { value: 'all', label: 'All' }]
            }),
            _react2.default.createElement(
              'div',
              { className: _generalSettings2.default.subtitle },
              ' of the following are true'
            )
          ),
          (0, _lodash.map)(pdParts, function (part, i) {
            var formKey = part.formKey;

            var Chosen = (0, _lodash.find)(progressiveDisclosures, { formKey: formKey });
            var prefix = 'progressiveDisclosure.parts.' + i;

            var configIsValid = (0, _lodash.get)(Chosen, 'validator', function () {
              return (0, _lodash.size)(part.data) > 0;
            });

            var className = _generalSettings2.default.pdPart;
            if (validating && (!part.data || !configIsValid(part.data))) {
              className += ' ' + _generalSettings2.default.incompletePDPart;
            }
            return _react2.default.createElement(
              'div',
              { key: i, className: className },
              _react2.default.createElement(
                _Buttons2.default,
                {
                  'aria-label': 'Remove Progressive Disclosure Row',
                  icon: true,
                  secondary: true,
                  onClick: function onClick() {
                    return _this2.handleRemovePdPart(i);
                  }
                },
                'delete'
              ),
              _react2.default.createElement(_kualiUi.SelectField, {
                'aria-label': 'Gadget Picker',
                className: _generalSettings2.default.select,
                onChange: function onChange(val) {
                  return _onChange(prefix + '.formKey', val);
                },
                value: (0, _lodash.get)(value, prefix + '.formKey'),
                menuItems: [{ value: '', label: '- - -' }].concat(_toConsumableArray((0, _lodash.reduce)(progressiveDisclosuresByParent, function (items, pdParent) {
                  if (pdParent.label) {
                    items.push(_react2.default.createElement(_kualiUi.Subheader, {
                      className: _generalSettings2.default.listSubheader,
                      key: '' + pdParent.id,
                      primaryText: pdParent.label
                    }));
                  }
                  return items.concat(pdParent.children.map(function (pd) {
                    return {
                      value: pd.formKey,
                      label: pd.label + ' (' + pd.formKey + ')'
                    };
                  }));
                }, [])))
              }),
              Chosen && _react2.default.createElement(Chosen.component, {
                context: _this2.props.context,
                value: (0, _lodash.get)(value, prefix + '.data', {}),
                onChange: function onChange(val) {
                  return _onChange(prefix + '.data', val);
                },
                details: Chosen.details
              })
            );
          })
        ),
        _react2.default.createElement(
          _Buttons2.default,
          {
            'aria-label': 'Add Progressive Disclosure Condition',
            floating: true,
            secondary: true,
            mini: true,
            onClick: this.handleAddPdPart
          },
          'add'
        )
      );
    }
  }]);

  return ProgressiveDisclosureConfigure;
}(_react.Component);

exports.default = ProgressiveDisclosureConfigure;