'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDnd = require('react-dnd');

var _configSideBar = require('./config-side-bar.css');

var _configSideBar2 = _interopRequireDefault(_configSideBar);

var _formbot = require('@kuali/formbot');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var FormbotConfigSideBar = function (_Component) {
  _inherits(FormbotConfigSideBar, _Component);

  function FormbotConfigSideBar() {
    _classCallCheck(this, FormbotConfigSideBar);

    var _this = _possibleConstructorReturn(this, (FormbotConfigSideBar.__proto__ || Object.getPrototypeOf(FormbotConfigSideBar)).call(this));

    _this.state = { chosenGroup: 0, chosenSection: 0 };
    return _this;
  }

  _createClass(FormbotConfigSideBar, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          Formbot = _props.Formbot,
          _props$classNames = _props.classNames,
          classNames = _props$classNames === undefined ? {} : _props$classNames,
          trashed = _props.trashed,
          template = _props.template;
      var _state = this.state,
          chosenGroup = _state.chosenGroup,
          chosenSection = _state.chosenSection;

      var sections = (0, _lodash.chain)(Formbot.context.gadgets).map(function (_ref, type) {
        var meta = _ref.meta;
        return _extends({}, meta, {
          getDragData: function getDragData() {
            var initialTemplate = (0, _lodash.isFunction)(meta.initialTemplate) ? meta.initialTemplate() : {};
            return _extends({}, initialTemplate, { type: type });
          }
        });
      }).filter(function (_ref2) {
        var hidden = _ref2.hidden;
        return !hidden;
      }).groupBy('category').map(function (items, lbl) {
        return { lbl: lbl, items: items };
      }).value();
      var templateByKey = (0, _lodash.keyBy)((0, _lodash.values)(_formbot.utils.gatherGadgetsById(template)), 'formKey');
      var trashItems = (0, _lodash.reduce)(trashed, function (memo, t) {
        if (!templateByKey[t.formKey]) {
          memo.push({
            icon: Formbot.getGadget(t.type).meta.icon,
            lbl: t.label,
            key: t.formKey,
            getDragData: function getDragData() {
              return (0, _lodash.cloneDeep)(t);
            }
          });
        }
        return memo;
      }, []);
      var trashedByKey = (0, _lodash.keyBy)(trashed, 'formKey');
      var presetItems = (0, _lodash.reduce)(Formbot.context.presets, function (memo, preset) {
        var data = preset.data,
            meta = preset.meta;

        if (!templateByKey[data.formKey] && !trashedByKey[data.formKey]) {
          memo.push(_extends({}, meta, {
            key: data.formKey,
            getDragData: function getDragData() {
              return (0, _lodash.cloneDeep)(data);
            }
          }));
        }
        return memo;
      }, []);
      var data = [{
        lbl: 'Gadgets',
        sections: sections
      }, {
        lbl: 'Presets',
        sections: [{ items: presetItems }]
      }, {
        lbl: 'Trash',
        sections: [{ items: trashItems }]
      }];
      return _react2.default.createElement(
        'div',
        null,
        (0, _lodash.map)(data, function (group, i) {
          return _react2.default.createElement(
            'div',
            {
              key: group.lbl || i,
              className: (0, _classnames2.default)(_configSideBar2.default.group, classNames.group)
            },
            _react2.default.createElement('div', {
              className: (0, _classnames2.default)(_configSideBar2.default.groupLbl, classNames.groupLbl),
              onClick: function onClick() {
                return _this2.setState({ chosenGroup: i, chosenSection: 0 });
              },
              children: group.lbl
            }),
            chosenGroup === i && _react2.default.createElement(
              'div',
              null,
              _react2.default.createElement(
                'div',
                { className: (0, _classnames2.default)(_configSideBar2.default.sections, classNames.sections) },
                (0, _lodash.map)(group.sections, function (section, j) {
                  if (!section.lbl) {
                    return null;
                  }
                  var className = (0, _classnames2.default)(_configSideBar2.default.sectionLbl, classNames.sectionLbl, _defineProperty({}, _configSideBar2.default.active, chosenSection === j));
                  return _react2.default.createElement('div', {
                    key: section.lbl || j,
                    onClick: function onClick() {
                      return _this2.setState({ chosenSection: j });
                    },
                    className: className,
                    children: section.lbl
                  });
                })
              ),
              _react2.default.createElement(
                'div',
                { className: (0, _classnames2.default)(_configSideBar2.default.section, classNames.section) },
                (0, _lodash.map)(group.sections[chosenSection].items, function (item) {
                  return _react2.default.createElement(ActualItem, { key: item.key || item.lbl, item: item });
                })
              )
            )
          );
        })
      );
    }
  }]);

  return FormbotConfigSideBar;
}(_react.Component);

FormbotConfigSideBar.displayName = 'FormbotConfigSideBar';
FormbotConfigSideBar.propTypes = {
  classNames: _propTypes2.default.object,
  Formbot: _propTypes2.default.object.isRequired,
  template: _propTypes2.default.object.isRequired,
  trashed: _propTypes2.default.array.isRequired
};
exports.default = FormbotConfigSideBar;

var Item = function (_Component2) {
  _inherits(Item, _Component2);

  function Item() {
    _classCallCheck(this, Item);

    return _possibleConstructorReturn(this, (Item.__proto__ || Object.getPrototypeOf(Item)).apply(this, arguments));
  }

  _createClass(Item, [{
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          item = _props2.item,
          isDragging = _props2.isDragging,
          connectDragSource = _props2.connectDragSource;

      var className = (0, _classnames2.default)(_configSideBar2.default.item, _defineProperty({}, _configSideBar2.default.dragging, isDragging));
      return connectDragSource(_react2.default.createElement(
        'div',
        { className: className },
        _react2.default.createElement('img', { className: _configSideBar2.default.icon, role: 'presentation', src: item.icon }),
        _react2.default.createElement(
          'div',
          null,
          item.lbl
        )
      ));
    }
  }]);

  return Item;
}(_react.Component);

Item.displayName = 'Item';
Item.propTypes = {
  connectDragSource: _propTypes2.default.func.isRequired,
  isDragging: _propTypes2.default.bool.isRequired,
  item: _propTypes2.default.object.isRequired
};


var itemSource = {
  beginDrag: function beginDrag(props) {
    return { data: props.item.getDragData() };
  }
};

function collect(connect, monitor) {
  return {
    connectDragSource: connect.dragSource(),
    isDragging: monitor.isDragging()
  };
}

var ActualItem = (0, _reactDnd.DragSource)('Gadget', itemSource, collect)(Item);