'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactMd = require('react-md');

var _formbot = require('@kuali/formbot');

var _config = require('./config.css');

var _config2 = _interopRequireDefault(_config);

var _builder = require('./builder');

var _builder2 = _interopRequireDefault(_builder);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var gatherGadgetsComplex = _formbot.utils.gatherGadgetsComplex,
    findGadgetsInProgDiscFromList = _formbot.utils.findGadgetsInProgDiscFromList;

var FormbotConfig = function (_Component) {
  _inherits(FormbotConfig, _Component);

  function FormbotConfig(props) {
    _classCallCheck(this, FormbotConfig);

    var _this = _possibleConstructorReturn(this, (FormbotConfig.__proto__ || Object.getPrototypeOf(FormbotConfig)).call(this, props));

    _this.handleCloseError = function () {
      _this.setState({ error: null });
    };

    _this.handleOnError = function (errors) {
      if (_this.props.onError) return _this.props.onError(errors);
      return _this.setState({ error: errors });
    };

    _this.onMove = function (gadget, target, direction, parentId) {
      var originalTemplate = _this.props.template;

      var template = (0, _lodash.cloneDeep)(originalTemplate);
      var gadgetPath = _formbot.utils.findGadgetPathById(template, gadget.id);
      var gadgetPathIndex = parseInt((0, _lodash.last)(gadgetPath.split('.')), 10);
      var gadgetParentPath = gadgetPath.split('.').slice(0, -1).join('.');

      var sourceChildren = (0, _lodash.get)(template, gadgetParentPath, []);
      sourceChildren.splice(gadgetPathIndex, 1);
      // If there is a target use that
      if (target) {
        var targetPath = _formbot.utils.findGadgetPathById(template, target.id);
        var targetParentPath = targetPath.split('.').slice(0, -1).join('.');

        var targetChildren = (0, _lodash.get)(template, targetParentPath, []);
        var targetIndex = (0, _lodash.findIndex)(targetChildren, function (item) {
          return item.id === target.id;
        });
        targetChildren.splice(targetIndex + direction, 0, gadget);
      }

      // if there is no target but there is a parentId add it to the parentId
      if (!target && parentId) {
        var _targetPath = _formbot.utils.findGadgetPathById(template, parentId);
        var _targetChildren = (0, _lodash.get)(template, _targetPath + '.children');
        _targetChildren.push(gadget);
      }

      return _this.props.onChange(template.id, template);
    };

    _this.onDelete = function (gadgetIdToDelete, isDeleted) {
      var _this$props = _this.props,
          template = _this$props.template,
          trash = _this$props.trashed,
          onChange = _this$props.onChange;

      var gadgetInstances = gatherGadgetsComplex(template, null, trash);
      var gadgetInstance = (0, _lodash.find)(gadgetInstances, { id: gadgetIdToDelete });
      var trashed = isDeleted ? template : null;
      if (!gadgetInstance.parent) {
        onChange({}, null, trashed);
      }
      // Don't delete gadgets that are used by, or have children used by others in prog. disclosure)
      var gadgetsUsedInProgressiveDisclosure = findGadgetsInProgDiscFromList(gadgetInstance, gadgetInstances);

      if (gadgetsUsedInProgressiveDisclosure.length > 0) {
        _this.handleOnError(gadgetsUsedInProgressiveDisclosure);
        return;
      }

      var newParent = (0, _lodash.cloneDeep)(gadgetInstance.parent);
      var childIndex = (0, _lodash.findIndex)(gadgetInstance.parent.children, function (child) {
        return child.id === gadgetIdToDelete;
      });
      if (childIndex !== -1) newParent.children.splice(childIndex, 1);
      onChange(gadgetInstance.parent.id, newParent, trashed);
    };

    _this.state = { error: null };
    return _this;
  }

  _createClass(FormbotConfig, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          context = _props.context,
          Formbot = _props.Formbot,
          className = _props.className,
          template = _props.template,
          mode = _props.mode,
          progDisc = _props.progDisc,
          trashed = _props.trashed,
          onChange = _props.onChange;
      var onClickSettings = this.props.onClickSettings;

      var gadgets = _formbot.utils.gatherGadgetsById(template);
      var data = (0, _lodash.reduce)(gadgets, function (memo, g) {
        var gadgetTmpl = Formbot.getGadget(g.type);
        if (!gadgetTmpl) return memo;
        memo[g.formKey] = gadgetTmpl.sampleValue || gadgetTmpl.defaultValue;
        return memo;
      }, {});
      var templateKeys = (0, _lodash.map)((0, _lodash.values)(gadgets), 'formKey');
      var trashKeys = (0, _lodash.map)(trashed, 'formKey');
      var presetKeys = (0, _lodash.keys)(Formbot.context.presets);
      var takenKeys = (0, _lodash.uniq)((0, _lodash.compact)([].concat(_toConsumableArray(templateKeys), _toConsumableArray(trashKeys), _toConsumableArray(presetKeys))));
      var classes = (0, _classnames2.default)(className, { 'ie-fixes': (0, _utils.detectIE)() });
      var errorClasses = (0, _classnames2.default)(className, _config2.default.errorMessage, _defineProperty({}, _config2.default['errorMessage-show'], this.state.error));
      return _react2.default.createElement(
        'div',
        { className: classes },
        _react2.default.createElement(
          'div',
          { className: errorClasses },
          _react2.default.createElement(
            _reactMd.Paper,
            { className: _config2.default.errorPaper },
            _react2.default.createElement(
              _reactMd.FontIcon,
              { className: _config2.default.errorIcon },
              'cancel'
            ),
            _react2.default.createElement(
              'div',
              { className: _config2.default.errorText },
              _react2.default.createElement(
                'h3',
                null,
                'Gadget cannot be deleted.'
              ),
              _react2.default.createElement(
                'p',
                null,
                'The following gadgets/fields have progressive disclosure dependencies'
              ),
              _react2.default.createElement(
                'ul',
                null,
                (0, _lodash.map)(this.state.error, function (message) {
                  return _react2.default.createElement(
                    'li',
                    null,
                    '"',
                    (0, _lodash.get)(message, 'progDiscGadget.label'),
                    '"',
                    _react2.default.createElement(
                      'emphasis',
                      null,
                      ' is dependent on '
                    ),
                    '"',
                    (0, _lodash.get)(message, 'targetGadget.label'),
                    '"'
                  );
                })
              )
            ),
            _react2.default.createElement(
              _reactMd.Button,
              { icon: true, onClick: this.handleCloseError },
              'close'
            )
          )
        ),
        mode === 'view' && Formbot.render('edit', template, trashed, data, {
          context: context,
          progDisc: progDisc,
          takenKeys: takenKeys,
          onChange: onChange,
          onClickSettings: onClickSettings,
          onError: this.handleOnError
        }),
        mode === 'edit' && _react2.default.createElement(_builder2.default, {
          template: template,
          trashed: trashed,
          onMove: this.onMove,
          onChange: onChange,
          onDelete: this.onDelete,
          onClickSettings: onClickSettings,
          gadgets: (0, _lodash.get)(Formbot, 'context.gadgets', {})
        })
      );
    }
  }]);

  return FormbotConfig;
}(_react.Component);

FormbotConfig.displayName = 'FormbotConfig';
FormbotConfig.propTypes = {
  className: _propTypes2.default.string,
  context: _propTypes2.default.any,
  Formbot: _propTypes2.default.object.isRequired,
  mode: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  onClickSettings: _propTypes2.default.func.isRequired,
  onError: _propTypes2.default.func,
  progDisc: _propTypes2.default.bool.isRequired,
  template: _propTypes2.default.object.isRequired,
  trashed: _propTypes2.default.array.isRequired
};
exports.default = FormbotConfig;