'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = FormbotEdit;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function FormbotEdit(props) {
  var className = props.className,
      context = props.context,
      data = props.data,
      Formbot = props.Formbot,
      multipageNum = props.multipageNum,
      onChange = props.onChange,
      template = props.template,
      trashed = props.trashed;

  var classes = (0, _classnames2.default)(className, { 'ie-fixes': (0, _utils.detectIE)() });
  return _react2.default.createElement(
    'div',
    { className: classes },
    Formbot.render('edit', template, trashed, data, {
      context: context,
      onChange: onChange,
      multipageNum: multipageNum
    })
  );
}

FormbotEdit.displayName = 'FormbotEdit';

FormbotEdit.propTypes = {
  className: _propTypes2.default.string,
  context: _propTypes2.default.any,
  data: _propTypes2.default.object.isRequired,
  Formbot: _propTypes2.default.object.isRequired,
  multipageNum: _propTypes2.default.number,
  onChange: _propTypes2.default.func.isRequired,
  template: _propTypes2.default.object.isRequired,
  trashed: _propTypes2.default.array.isRequired
};