/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

/* eslint react/display-name: 1 */

import React from 'react'

import Config from './lib/config'
import ConfigOptions from './lib/config-options'
import ConfigSettings from './lib/config-settings'
import ConfigSideBar from './lib/config-side-bar'
import ConfigWrapper from './lib/config-wrapper'
import Edit from './lib/edit'
import View from './lib/view'

export function bind (Formbot) {
  return {
    Edit: wrap(Edit, Formbot),
    View: wrap(View, Formbot),
    Config: wrap(Config, Formbot),
    ConfigOptions: wrap(ConfigOptions, Formbot),
    ConfigSettings: wrap(ConfigSettings, Formbot),
    ConfigSideBar: wrap(ConfigSideBar, Formbot),
    ConfigWrapper: wrap(ConfigWrapper, Formbot)
  }
}

function wrap (Component, Formbot) {
  return props => <Component {...props} Formbot={Formbot} />
}
