/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import Toggle from '@kuali/common/toggle'
import React, { Component } from 'react'
import PropTypes from 'prop-types'
import Checkbox from 'react-md/lib/SelectionControls/Checkbox'

import styles from './config-options.css'

export default class FormbotConfigSideBar extends Component {
  static displayName = 'FormbotConfigSideBar'

  static propTypes = {
    state: PropTypes.object.isRequired,
    update: PropTypes.func.isRequired,
    hideProgDiscCheckbox: PropTypes.bool
  }

  constructor () {
    super()
    this.state = {
      chosenGroup: 0,
      chosenSection: 0
    }
  }

  render () {
    const { state, update, hideProgDiscCheckbox } = this.props
    return (
      <div>
        <Toggle
          values={{ edit: 'Edit', view: 'View' }}
          value={state.mode}
          onChange={mode => update({ ...state, mode })}
        />
        {!hideProgDiscCheckbox && (
          <div className={styles.checks}>
            <Checkbox
              checked={state.progDisc}
              id='show-prog-disc'
              name='show-prog-disc'
              label='Show Progressive Disclosure'
              onChange={progDisc => update({ ...state, progDisc })}
            />
          </div>
        )}
      </div>
    )
  }
}
