/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */
import { partialRight, merge } from 'lodash'
import _sanitize from 'sanitize-html'

export function detectIE () {
  if (typeof window === 'undefined') return false
  const msie = window.navigator.userAgent.indexOf('MSIE ')
  const trident = window.navigator.userAgent.indexOf('Trident/')
  return msie > 0 || trident > 0
}

const extendedAllowedAttributes = merge(
  {},
  _sanitize.defaults.allowedAttributes,
  {
    '*': ['class', 'style']
  }
)

const extendedAllowedTags = _sanitize.defaults.allowedTags.concat([
  'span',
  's',
  'u'
])

export const sanitize = partialRight(_sanitize, {
  allowedAttributes: extendedAllowedAttributes,
  allowedTags: extendedAllowedTags
})
