'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _axios = require('axios');

var _axios2 = _interopRequireDefault(_axios);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var instance = _axios2.default.create(); /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                          * You may use and modify this code under the terms of the Kuali, Inc.
                                          * Pre-Release License Agreement. You may not distribute it.
                                          *
                                          * You should have received a copy of the Kuali, Inc. Pre-Release License
                                          * Agreement with this file. If not, please write to license@kuali.co.
                                          */

instance.interceptors.request.use(function (config) {
  if (!config.headers['Content-Type']) {
    config.headers['Content-Type'] = 'application/json';
  }
  var parsedCookie = /authToken=(.+?)(;|$)/.exec(document.cookie) || [];
  var token = parsedCookie[1];
  if (!config.headers.Authorization && token) {
    config.headers.Authorization = 'Bearer ' + token;
  }
  config.withCredentials = true;
  return config;
},
/* istanbul ignore next */
function (error) {
  console.log(error); // eslint-disable-line no-console
});

exports.default = instance;