'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DraggableGadget = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

/* eslint import/max-dependencies: 0 */

exports.default = renderGadget;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactDnd = require('react-dnd');

var _Buttons = require('react-md/lib/Buttons');

var _Buttons2 = _interopRequireDefault(_Buttons);

var _FontIcons = require('react-md/lib/FontIcons');

var _FontIcons2 = _interopRequireDefault(_FontIcons);

var _TextFields = require('react-md/lib/TextFields');

var _TextFields2 = _interopRequireDefault(_TextFields);

var _gadgetRenderer = require('./gadget-renderer.css');

var _gadgetRenderer2 = _interopRequireDefault(_gadgetRenderer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function renderGadget(Formbot, mode, template, options) {
  var gadget = options.originalRender(Formbot, mode, template, _extends({}, options, {
    shouldShow: true,
    onChange: _lodash.noop
  }));
  var gadgetDefinition = Formbot.getGadget(template.type);
  if (!template.formKey && !gadgetDefinition.layout) {
    gadget = _react2.default.createElement(NoFormKey, {
      setKey: function setKey(label) {
        var formKey = (0, _lodash.camelCase)(label);
        for (var i = 1; (0, _lodash.includes)(options.takenKeys, formKey); ++i) {
          formKey = (0, _lodash.camelCase)(label) + i;
        }
        options.onChange(_extends({}, template, { formKey: formKey, label: label }));
      }
    });
  }
  return _react2.default.createElement(DraggableGadget, {
    key: template.id,
    options: options,
    gadget: gadget,
    template: template
  });
}

var _DraggableGadget = function (_Component) {
  _inherits(_DraggableGadget, _Component);

  function _DraggableGadget() {
    _classCallCheck(this, _DraggableGadget);

    return _possibleConstructorReturn(this, (_DraggableGadget.__proto__ || Object.getPrototypeOf(_DraggableGadget)).apply(this, arguments));
  }

  _createClass(_DraggableGadget, [{
    key: 'render',
    value: function render() {
      var _cx;

      var _props = this.props,
          gadget = _props.gadget,
          options = _props.options,
          connectDragPreview = _props.connectDragPreview,
          connectDragSource = _props.connectDragSource,
          isDragging = _props.isDragging;
      var shouldShowConfig = options.shouldShowConfig,
          shouldShow = options.shouldShow,
          onClickSettings = options.onClickSettings,
          removeMe = options.removeMe;

      if (!shouldShowConfig) return null;
      var wrapperStyles = (0, _classnames2.default)(_gadgetRenderer2.default.configContainer, this.props.className, (_cx = {}, _defineProperty(_cx, _gadgetRenderer2.default.shouldHide, !shouldShow), _defineProperty(_cx, _gadgetRenderer2.default.isDragging, isDragging), _cx));
      return connectDragPreview(_react2.default.createElement(
        'div',
        { className: wrapperStyles },
        _react2.default.createElement(
          'div',
          { className: _gadgetRenderer2.default.configIcons },
          connectDragSource(_react2.default.createElement(
            'span',
            { className: (0, _classnames2.default)(_gadgetRenderer2.default.draggerContainer, _gadgetRenderer2.default.smallIcon) },
            _react2.default.createElement(
              _FontIcons2.default,
              { className: _gadgetRenderer2.default.dragger },
              'drag_handle'
            )
          )),
          _react2.default.createElement(
            _Buttons2.default,
            {
              icon: true,
              onClick: onClickSettings,
              style: { width: 16, height: 16, padding: 0 },
              className: _gadgetRenderer2.default.smallIcon
            },
            'settings'
          ),
          _react2.default.createElement(
            _Buttons2.default,
            {
              icon: true,
              onClick: removeMe,
              style: { width: 16, height: 16, padding: 0 },
              className: _gadgetRenderer2.default.smallIcon
            },
            'delete'
          )
        ),
        gadget
      ));
    }
  }]);

  return _DraggableGadget;
}(_react.Component);

_DraggableGadget.displayName = 'DraggableGadget';
_DraggableGadget.propTypes = {
  className: _propTypes2.default.string,
  connectDragPreview: _propTypes2.default.func.isRequired,
  connectDragSource: _propTypes2.default.func.isRequired,
  gadget: _propTypes2.default.node.isRequired,
  isDragging: _propTypes2.default.bool.isRequired,
  options: _propTypes2.default.object.isRequired
};


var gadgetSource = {
  beginDrag: function beginDrag(props) {
    return {
      data: (0, _lodash.cloneDeep)(props.template),
      cancelUpdate: true
    };
  },
  endDrag: function endDrag(props, monitor) {
    if (monitor.didDrop()) {
      props.options.removeMe();
    }
  }
};

function collect(connect, monitor) {
  return {
    connectDragSource: connect.dragSource(),
    connectDragPreview: connect.dragPreview(),
    isDragging: monitor.isDragging()
  };
}

var DraggableGadget = exports.DraggableGadget = (0, _reactDnd.DragSource)('Gadget', gadgetSource, collect)(_DraggableGadget);

var NoFormKey = function (_Component2) {
  _inherits(NoFormKey, _Component2);

  function NoFormKey() {
    _classCallCheck(this, NoFormKey);

    var _this2 = _possibleConstructorReturn(this, (NoFormKey.__proto__ || Object.getPrototypeOf(NoFormKey)).call(this));

    _this2.handleSaveOnEnter = function (e) {
      if (e.keyCode === 13) _this2.handleSave();
    };

    _this2.handleSave = function () {
      var setKey = _this2.props.setKey;
      var key = _this2.state.key;

      if (!key) {
        _this2.setState({ error: 'Label must not be blank.' });
        return;
      }
      setKey(key);
    };

    _this2.state = {
      key: '',
      error: null
    };
    return _this2;
  }

  _createClass(NoFormKey, [{
    key: 'render',
    value: function render() {
      var _this3 = this;

      var _state = this.state,
          key = _state.key,
          error = _state.error;

      return _react2.default.createElement(
        'div',
        { className: _gadgetRenderer2.default.noFormKey },
        _react2.default.createElement(_TextFields2.default, {
          error: error,
          errorText: error,
          label: 'Label',
          placeholder: 'What do you want to call this field?',
          onChange: function onChange(val) {
            return _this3.setState({ key: val });
          },
          onKeyDown: this.handleSaveOnEnter,
          fullWidth: true,
          value: key
        }),
        _react2.default.createElement(_Buttons2.default, { primary: true, raised: true, label: 'Save', onClick: this.handleSave })
      );
    }
  }]);

  return NoFormKey;
}(_react.Component);

NoFormKey.displayName = 'NoFormKey';
NoFormKey.propTypes = {
  setKey: _propTypes2.default.func.isRequired
};