'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.buildHeadingParts = buildHeadingParts;
exports.default = renderGadget;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _utils = require('./utils');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _kualiUi = require('@kuali/kuali-ui');

var _reactMd = require('react-md');

var _gadgetRenderer = require('./gadget-renderer.css');

var _gadgetRenderer2 = _interopRequireDefault(_gadgetRenderer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                   *
                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                   */

var ERROR_STYLE = {
  backgroundColor: '#D9534F',
  color: 'white',
  padding: 15,
  fontSize: 20,
  textAlign: 'center'
};

function buildHeadingParts(Formbot, mode, template) {
  var _cx;

  var label = template.label && (0, _lodash.get)(template, 'displayLabel', !(0, _lodash.get)(template, 'displayQuestionOnly', false)) && _react2.default.createElement(
    'label',
    { className: _gadgetRenderer2.default.label },
    template.label
  );
  var question = template.question && (0, _lodash.get)(template, 'displayQuestion', true) && _react2.default.createElement('p', {
    className: _gadgetRenderer2.default.question + ' ' + _gadgetRenderer2.default.richText + ' ql-editor',
    dangerouslySetInnerHTML: { __html: (0, _utils.sanitize)(template.question) }
  });
  var displayDescriptionInline = (0, _lodash.get)(template, 'displayDescInline', true);
  var descInner = template.desc && _react2.default.createElement('p', {
    className: (0, _classnames2.default)((_cx = {}, _defineProperty(_cx, _gadgetRenderer2.default.desc, displayDescriptionInline), _defineProperty(_cx, _gadgetRenderer2.default.descTooltip, !displayDescriptionInline), _cx), _gadgetRenderer2.default.richText, 'ql-editor'),
    dangerouslySetInnerHTML: { __html: (0, _utils.sanitize)(template.desc) }
  });
  var desc = mode === 'edit' && descInner && (displayDescriptionInline ? descInner : _react2.default.createElement(
    _reactMd.Tooltipped,
    { label: descInner, position: 'right' },
    _react2.default.createElement(
      'span',
      { className: _gadgetRenderer2.default.tooltipWrapper },
      _react2.default.createElement(_kualiUi.Icon, { name: 'help', variant: 'info' })
    )
  ));

  return { label: label, desc: desc, question: question };
}

function renderGadget(Formbot, mode, template, options) {
  var context = options.context,
      children = options.children,
      dependent = options.dependent,
      fbRender = options.fbRender,
      shouldShow = options.shouldShow,
      onChange = options.onChange,
      value = options.value;


  var gadgetDef = Formbot.getGadget(template.type);
  var Gadget = gadgetDef[mode];

  if (!shouldShow || !template.formKey && !gadgetDef.layout) return null;

  createErrorBoundary(Gadget);
  var wrapperStyles = (0, _classnames2.default)(_gadgetRenderer2.default.gadget, _gadgetRenderer2.default['size-' + (template.fieldSize || 'large')], _defineProperty({}, _gadgetRenderer2.default.noPad, options.noPad));

  var a11yDesc = template.label;
  var props = {
    context: context,
    formKey: template.formKey,
    id: template.id,
    value: value,
    onChange: onChange,
    dependent: dependent || {},
    fbRender: fbRender,
    details: template.details || {},
    children: children,
    NOTFOUND_TYPE: template.type,
    a11yDesc: a11yDesc
  };
  var decorators = Formbot.getDecorators({ type: template.type, mode: mode });
  var headerParts = buildHeadingParts(Formbot, mode, template);
  var createComponent = function createComponent(_props) {
    var gadget = _react2.default.createElement(Gadget, _props);
    var parts = decorators.length ? Formbot.decorate(decorators, _extends({}, headerParts, { gadget: gadget }), _extends({}, _props, { template: template }), gadgetDef) : _extends({}, headerParts, { gadget: gadget });

    return _react2.default.createElement(
      'div',
      { className: wrapperStyles, key: template.id },
      parts.label,
      parts.question,
      parts.desc,
      parts.gadget
    );
  };
  var component = createComponent(props);
  var decProps = _extends({}, props, { template: template });
  return decorators.length ? Formbot.decorate(decorators, { component: component }, decProps, gadgetDef, createComponent).component : component;
}

// This is the best we can do until we upgrade to React 15, in which version
// they released Error Boundaries
// https://github.com/facebook/react/pull/5602
// https://github.com/facebook/react/pull/6020
// Also to note: this won't work in dev mode. We use a library that catches our
// errors for us (before we can catch it here) and throws up a big red screen.
function createErrorBoundary(Component) {
  if (Component.prototype.originalRender) {
    return;
  }
  Component.prototype.originalRender = Component.prototype.render;
  Component.prototype.render = function render() {
    try {
      return Component.prototype.originalRender.call(this);
    } catch (e) {
      console.error(e);
      return _react2.default.createElement(
        'div',
        { style: ERROR_STYLE },
        'Sorry! This piece of the form is temporarily unavailable.'
      );
    }
  };
}