'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

exports.default = fbRender;

var _lodash = require('lodash');

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function fbRender(Formbot, mode, template, data, gadgetInstances) {
  var props = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};

  if (!template.id) {
    return Formbot.renderEmptyForm(Formbot, mode, props);
  }
  if (!template.root) template.root = true;
  return renderGadget(Formbot, gadgetInstances, mode, data, props)(template);
}

function renderGadget(Formbot, gadgetInstances, mode, data, props) {
  function renderGadgetInternal(template) {
    var middlewares = Formbot.middlewareTransformer([progressiveDisclosure, attachTakenKeys, renderChildren, bindDataHandlers, linkDependentData, chooseRenderer]);
    var args = [Formbot, mode, template, data, props, gadgetInstances, renderGadgetInternal];
    var options = (0, _lodash.reduce)(middlewares, function (memo, mw) {
      return _extends({}, memo, mw.apply(undefined, args));
    }, {
      fbRender: fbRender.bind(null, Formbot),
      context: props.context,
      noPad: props.noPad
    });

    return options.render(Formbot, mode, template, options);
  }
  return renderGadgetInternal;
}

function progressiveDisclosure(Formbot, _mode, template, data, props, gadgetInstances) {
  if (!template.progressiveDisclosure) {
    return { shouldShow: true, shouldShowConfig: true };
  }
  var combineFn = template.progressiveDisclosure.type === 'any' ? _lodash.some : _lodash.every;
  var parts = (0, _lodash.filter)(template.progressiveDisclosure.parts, function (p) {
    return p.formKey;
  });
  var shouldShow = combineFn(parts, function (part) {
    var formKey = part.formKey;

    var progDiscDef = (0, _lodash.find)(Formbot.getProgressiveDisclosures(), { formKey: formKey });
    if (progDiscDef) return progDiscDef.check((0, _lodash.get)(data, formKey), part.data);
    var gadgetInstance = (0, _lodash.find)(gadgetInstances, { formKey: formKey });
    var gadgetDefinition = Formbot.getGadget(gadgetInstance.type);
    var actual = (0, _lodash.get)(data, formKey) || gadgetDefinition.defaultValue;
    var expected = part.data;
    return gadgetDefinition.progressiveDisclosure.check(actual, expected);
  });
  return { shouldShow: shouldShow, shouldShowConfig: shouldShow || props.progDisc };
}

function attachTakenKeys(_Formbot, _mode, _template, _data, props) {
  if (!props.takenKeys) return {};
  return { takenKeys: props.takenKeys };
}

function renderChildren(_Formbot, _mode, template, _data, _props, _gadgetInstances, _renderGadget) {
  if (!template.children) return {};
  return {
    children: (0, _lodash.compact)((0, _lodash.map)(template.children, _renderGadget)),
    childrenTemplates: template.children
  };
}

function bindDataHandlers(Formbot, _mode, template, data, props) {
  var obj = {};
  var gadgetDefinition = Formbot.getGadget(template.type);
  obj.value = data[template.formKey] || gadgetDefinition.defaultValue;
  obj.onChange = _lodash.noop;
  if (props.onChange) {
    obj.onChange = function (newVal, path) {
      var newPath = path || path === 0 ? template.formKey + '.' + path : template.formKey;
      return props.onChange(newPath, newVal);
    };
  }
  return obj;
}

function linkDependentData(Formbot, _mode, template, data, _props, gadgetInstances) {
  var _Formbot$getGadget = Formbot.getGadget(template.type),
      getDependentKeys = _Formbot$getGadget.getDependentKeys;

  if (!(0, _lodash.isFunction)(getDependentKeys)) return {};
  var dependentKeys = getDependentKeys(template.details);
  var dependentData = (0, _lodash.reduce)(dependentKeys.data, function (prev, key) {
    return _extends({}, prev, _defineProperty({}, key, data[key]));
  }, {});
  var dataGadgets = (0, _lodash.filter)(gadgetInstances, 'formKey');
  dataGadgets = (0, _lodash.keyBy)(dataGadgets, 'formKey');
  var dependentTemplate = (0, _lodash.reduce)(dependentKeys.template, function (prev, key) {
    (0, _lodash.set)(prev, key, (0, _lodash.get)(dataGadgets, key));
    return prev;
  }, {});
  return {
    dependent: { data: dependentData, template: dependentTemplate }
  };
}

function chooseRenderer(Formbot, _mode, template, _data, props) {
  var GadgetDef = Formbot.getGadget(template.type);
  var originalRender = GadgetDef.customGadgetRenderer || Formbot.renderGadget;
  var render = originalRender;
  return { originalRender: originalRender, render: render };
}