const fs = require('fs')

const gulp = require('gulp')
const babel = require('gulp-babel')
const postcss = require('gulp-postcss')
const concat = require('gulp-concat')

const modules = require('postcss-modules')
const autoprefixer = require('autoprefixer')
const del = require('del')

gulp.task('js', ['clean'], () => {
  return gulp
    .src(['src/**/*.js', '!src/**/*.test.js'])
    .pipe(
      babel({
        presets: ['env', 'es2015', 'react', 'stage-1']
      })
    )
    .pipe(gulp.dest('dist'))
})

gulp.task('css', ['clean', 'js'], () => {
  return gulp
    .src('src/**/*.css')
    .pipe(
      postcss([
        autoprefixer,
        modules({
          generateScopedName: 'formbot_[local]_[hash:base64:2]',
          getJSON: (cssFileName, json) => {
            const cssName = cssFileName
              .replace(__dirname, '.')
              .replace('./src', './dist')
            fs.writeFileSync(
              `${cssName}.js`,
              `module.exports = ${JSON.stringify(json)}`
            )
          }
        })
      ])
    )
    .pipe(concat('style.css'))
    .pipe(gulp.dest('./dist'))
})

gulp.task('clean', () => {
  return del('dist')
})

gulp.task('build', ['clean', 'js', 'css'])

gulp.task('default', ['build'])
