'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.component = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.check = check;
exports.configIsValid = configIsValid;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _TextFields = require('react-md/lib/TextFields');

var _TextFields2 = _interopRequireDefault(_TextFields);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

function check() {
  var data = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var config = arguments[1];

  var correctedData = (0, _utils.convertTruthyKeys)(data);
  switch (config.type) {
    case 'isChecked':
      return (0, _lodash.includes)(correctedData, config.value);
    case 'isNotChecked':
      return !(0, _lodash.includes)(correctedData, config.value);
    case 'numChecked':
      return correctedData.length >= config.value;
    case 'numNotChecked':
      return correctedData.length < config.value;
    default:
      return true;
  }
}

function configIsValid(configData) {
  return configData.type && configData.value;
}

var component = exports.component = function (_Component) {
  _inherits(component, _Component);

  function component() {
    _classCallCheck(this, component);

    return _possibleConstructorReturn(this, (component.__proto__ || Object.getPrototypeOf(component)).apply(this, arguments));
  }

  _createClass(component, [{
    key: 'renderSuffix',
    value: function renderSuffix(type) {
      if (!type) return null;
      var _props = this.props,
          details = _props.details,
          _onChange = _props.onChange,
          value = _props.value;

      if ((0, _lodash.includes)(['isChecked', 'isNotChecked'], type)) {
        var options = details.options || [];
        return _react2.default.createElement(
          'div',
          { style: { display: 'flex', flex: 2, width: 0 } },
          _react2.default.createElement(_kualiUi.SelectField, {
            id: type,
            className: 'pg-suffix',
            onChange: function onChange(newVal) {
              return _onChange(_extends({}, value, { value: newVal }));
            },
            style: { flex: 1, margin: '0 10px' },
            value: value.value || '',
            menuItems: [{ key: '', lbl: '- - -' }].concat(_toConsumableArray(options)),
            itemLabel: 'lbl',
            itemValue: 'key'
          }),
          _react2.default.createElement(
            'div',
            { style: { flex: 1, margin: 'auto' } },
            ' checked'
          )
        );
      }
      if ((0, _lodash.includes)(['numChecked', 'numNotChecked'], type)) {
        return _react2.default.createElement(
          'div',
          { style: { display: 'flex', flex: 2, width: 0 } },
          _react2.default.createElement(_TextFields2.default, {
            className: 'pg-suffix',
            onChange: function onChange(val) {
              return _onChange(_extends({}, value, { value: val }));
            },
            style: { flex: 1, margin: '0 10px' },
            type: 'number',
            value: value.value
          }),
          _react2.default.createElement(
            'div',
            { style: { flex: 2, margin: 'auto' } },
            ' items checked'
          )
        );
      }
      return null;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          id = _props2.id,
          _onChange2 = _props2.onChange,
          value = _props2.value;

      return _react2.default.createElement(
        'div',
        { style: { display: 'flex', flex: 3 } },
        _react2.default.createElement(_kualiUi.SelectField, {
          id: id,
          onChange: function onChange(type) {
            return _onChange2(_extends({}, value, { type: type }));
          },
          style: { flex: 1 },
          value: value.type || '',
          menuItems: [{ key: '', lbl: '- - -' }, { key: 'isChecked', lbl: 'has' }, { key: 'isNotChecked', lbl: 'does not have' }, { key: 'numChecked', lbl: 'has at least' }, { key: 'numNotChecked', lbl: 'has less than' }],
          itemLabel: 'lbl',
          itemValue: 'key'
        }),
        this.renderSuffix(value.type)
      );
    }
  }]);

  return component;
}(_react.Component);

component.displayName = 'ProgressiveDisclosure';
component.propTypes = {
  id: _propTypes2.default.string.isRequired,
  details: _propTypes2.default.object.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.object.isRequired
};