'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = CheckboxesView;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function CheckboxesView(_ref) {
  var _ref$value = _ref.value,
      value = _ref$value === undefined ? [] : _ref$value,
      details = _ref.details;

  var options = (0, _lodash.filter)(details.options, function (o) {
    return o.key;
  });
  var correctedValue = (0, _utils.convertTruthyKeys)(value);
  return _react2.default.createElement(
    'div',
    null,
    (0, _lodash.map)(options, function (o) {
      return (0, _lodash.includes)(correctedValue, o.key) ? _react2.default.createElement(
        'div',
        { key: o.key },
        o.lbl
      ) : null;
    })
  );
}

CheckboxesView.displayName = 'CheckboxesView';

CheckboxesView.propTypes = {
  details: _propTypes2.default.object.isRequired,
  value: _propTypes2.default.oneOfType([_propTypes2.default.object.isRequired, _propTypes2.default.array.isRequired])
};