'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _DatePickerContainer = require('react-md/lib/Pickers/DatePickerContainer');

var _DatePickerContainer2 = _interopRequireDefault(_DatePickerContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function DateEdit(_ref) {
  var details = _ref.details,
      formKey = _ref.formKey,
      _onChange = _ref.onChange,
      value = _ref.value;

  var placeholder = (0, _lodash.get)(details, 'placeholder', '');
  return _react2.default.createElement(_DatePickerContainer2.default, {
    autoOk: true,
    formatOptions: { month: 'long', day: 'numeric', year: 'numeric' },
    fullWidth: true,
    id: formKey,
    label: placeholder,
    onChange: function onChange(dateString) {
      /* IE 11 doesn't handle Unicode characters well and
         dateString contains invisible #8206s (left-to-right-mark) */
      var ansiDateString = dateString.replace(/(?:[\x80-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])/g, '');
      _onChange(ansiDateString);
    },
    portal: true,
    value: value ? new Date(value) : null
  });
}

exports.default = DateEdit;
DateEdit.displayName = 'DateEdit';

DateEdit.propTypes = {
  details: _propTypes2.default.shape({
    placeholder: _propTypes2.default.string
  }).isRequired,
  formKey: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.string
};