'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createDropdownEdit;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                     * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                     * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                     *
                                                                                                                                                                                                     * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                     * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                     */

function createDropdownEdit(options, hasMultiple) {
  function LocationEdit(_ref) {
    var formKey = _ref.formKey,
        _onChange = _ref.onChange,
        value = _ref.value;

    var children = hasMultiple ? (0, _lodash.flatten)((0, _lodash.map)(options, 'options')) : options;
    return _react2.default.createElement(_kualiUi.SelectField, {
      id: formKey,
      onChange: function onChange(val) {
        return _onChange(val);
      },
      value: value,
      menuItems: [{ key: '', lbl: '- - -' }].concat(_toConsumableArray(children)),
      itemLabel: 'lbl',
      itemValue: 'key'
    });
  }
  LocationEdit.displayName = 'LocationEdit';
  LocationEdit.propTypes = {
    details: _propTypes2.default.object.isRequired,
    formKey: _propTypes2.default.string.isRequired,
    id: _propTypes2.default.string.isRequired,
    onChange: _propTypes2.default.func.isRequired,
    value: _propTypes2.default.string.isRequired
  };
  return LocationEdit;
}