'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StateDropdown = exports.LanguagesDropdown = exports.CountryDropdown = undefined;

var _lodash = require('lodash');

var _data = require('./data');

var _edit = require('./edit');

var _edit2 = _interopRequireDefault(_edit);

var _progressiveDisclosure = require('./progressive-disclosure');

var _progressiveDisclosure2 = _interopRequireDefault(_progressiveDisclosure);

var _validations = require('./validations');

var _validations2 = _interopRequireDefault(_validations);

var _view = require('./view');

var _view2 = _interopRequireDefault(_view);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function buildGadget(lbl, _options, hasMultiple) {
  var options = hasMultiple ? (0, _lodash.flatten)((0, _lodash.map)(_options, 'options')) : _options;
  return {
    view: (0, _view2.default)(options),
    edit: (0, _edit2.default)(_options, hasMultiple),

    validateShape: (0, _validations2.default)(options),

    progressiveDisclosure: (0, _progressiveDisclosure2.default)(options),

    defaultValue: '',

    sampleValue: '',

    meta: {
      lbl: lbl + ' Drop Down',
      icon: 'extension',
      category: 'Elements',
      sizes: ['small', 'medium', 'large', 'xlarge']
    }
  };
}

var CountryDropdown = exports.CountryDropdown = buildGadget('Country', _data.countries);
var LanguagesDropdown = exports.LanguagesDropdown = buildGadget('Language', _data.languages);
var StateDropdown = exports.StateDropdown = buildGadget('State/Province', [{ lbl: 'States', options: _data.states }, { lbl: 'Provinces', options: _data.provinces }], true);