'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

exports.default = createProgDisc;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

function createProgDisc(options) {
  function check(data, config) {
    switch (config.type) {
      case 'isSelected':
        return data === config.value;
      case 'isNotSelected':
        return data !== config.value;
      default:
        return true;
    }
  }

  function configIsValid(configData) {
    return configData.type && configData.value;
  }

  var component = function (_Component) {
    _inherits(component, _Component);

    function component() {
      _classCallCheck(this, component);

      return _possibleConstructorReturn(this, (component.__proto__ || Object.getPrototypeOf(component)).apply(this, arguments));
    }

    _createClass(component, [{
      key: 'link',
      value: function link(key) {
        var _props = this.props,
            value = _props.value,
            onChange = _props.onChange;

        return {
          value: value[key] || '',
          requestChange: function requestChange(val) {
            return onChange(_extends({}, value, _defineProperty({}, key, val)));
          }
        };
      }
    }, {
      key: 'render',
      value: function render() {
        var _props2 = this.props,
            value = _props2.value,
            _onChange = _props2.onChange,
            formKey = _props2.formKey;

        return _react2.default.createElement(
          'div',
          { style: { display: 'flex', flex: 2, width: 0 } },
          _react2.default.createElement(_kualiUi.SelectField, {
            id: formKey,
            onChange: function onChange(type) {
              return _onChange(_extends({}, value, { type: type }));
            },
            style: { flex: 1, marginRight: 10 },
            value: value.type || '',
            menuItems: [{ value: '', label: '- - -' }, { value: 'isSelected', label: 'is' }, { value: 'isNotSelected', label: 'is not' }]
          }),
          _react2.default.createElement(_kualiUi.SelectField, {
            id: formKey,
            onChange: function onChange(newVal) {
              return _onChange(_extends({}, value, { value: newVal }));
            },
            style: { flex: 1 },
            value: value.value || '',
            menuItems: [{ key: '', lbl: '- - -' }].concat(_toConsumableArray(options)),
            itemLabel: 'lbl',
            itemValue: 'key'
          })
        );
      }
    }]);

    return component;
  }(_react.Component);

  component.displayName = 'ProgressiveDisclosure';
  component.propTypes = {
    details: _propTypes2.default.object.isRequired,
    onChange: _propTypes2.default.func.isRequired,
    value: _propTypes2.default.object.isRequired,
    formKey: _propTypes2.default.string.isRequired
  };


  return { check: check, component: component, configIsValid: configIsValid };
}