'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.component = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

exports.check = check;
exports.configIsValid = configIsValid;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _TextFields = require('react-md/lib/TextFields');

var _TextFields2 = _interopRequireDefault(_TextFields);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function check(data, config) {
  switch (config.type) {
    case 'equalTo':
      return data && data === config.value;
    case 'greaterThan':
      return data && data > config.value;
    case 'lessThan':
      return data && data < config.value;
    case 'greaterThanOrEqualTo':
      return data && data >= config.value;
    case 'lessThanOrEqualTo':
      return data && data <= config.value;
    case 'notEqualTo':
      return data && data !== config.value;
    default:
      return true;
  }
}

function configIsValid(configData) {
  return configData.type && configData.value;
}

function component(_ref) {
  var id = _ref.id,
      _onChange = _ref.onChange,
      value = _ref.value;

  return _react2.default.createElement(
    'div',
    { className: _style2.default.progDisc },
    _react2.default.createElement(_kualiUi.SelectField, {
      id: id,
      className: _style2.default.select,
      onChange: function onChange(type) {
        return _onChange(_extends({}, value, { type: type }));
      },
      value: value.type || '',
      menuItems: [{ value: '', label: '- - -' }, { value: 'equalTo', label: 'is Equal to' }, { value: 'notEqualTo', label: 'is Not Equal to' }, { value: 'greaterThan', label: 'is Greater than' }, { value: 'lessThan', label: 'is Less than' }, {
        value: 'greaterThanOrEqualTo',
        label: 'is Greater than or Equal to'
      }, { value: 'lessThanOrEqualTo', label: 'is Less than or Equal to' }]
    }),
    _react2.default.createElement(_TextFields2.default, {
      type: 'number',
      onChange: function onChange(val) {
        return _onChange(_extends({}, value, { value: val }));
      },
      style: { flex: 1 },
      value: value.value || ''
    })
  );
}

exports.component = component;
component.displayName = 'ProgressiveDisclosure';

component.propTypes = {
  id: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.shape({
    value: _propTypes2.default.string,
    type: _propTypes2.default.string
  }).isRequired
};