'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _sanitize = require('./sanitize');

var _sanitize2 = _interopRequireDefault(_sanitize);

var _styles = require('./styles.css');

var _styles2 = _interopRequireDefault(_styles);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

var Quill = void 0;
if (typeof document !== 'undefined') {
  Quill = require('react-quill');
}

var toolbarItems = [[{ font: [] }], [{ size: [] }], [{ align: [] }], ['bold', 'italic', 'strike', 'underline'], [{ color: [] }, { background: [] }], [{ list: 'ordered' }, { list: 'bullet' }], ['link']];

var keyboard = {
  bindings: {
    tab: {
      key: 9,
      handler: function handler() {
        return true;
      } // allow normal tab key event propagation
    }
  }
};

function RichTextEdit(_ref) {
  var _onChange = _ref.onChange,
      _ref$value = _ref.value,
      value = _ref$value === undefined ? '' : _ref$value;

  return _react2.default.createElement(
    'div',
    { className: _styles2.default.edit },
    _react2.default.createElement(Quill, {
      theme: 'snow',
      defaultValue: (0, _sanitize2.default)(value),
      modules: { toolbar: toolbarItems, keyboard: keyboard },
      onChange: function onChange(val) {
        return _onChange(val);
      }
    })
  );
}

exports.default = RichTextEdit;
RichTextEdit.displayName = 'RichTextEdit';

RichTextEdit.propTypes = {
  details: _propTypes2.default.object.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.string.isRequired
};