'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lodash = require('lodash');

var _sanitizeHtml = require('sanitize-html');

var _sanitizeHtml2 = _interopRequireDefault(_sanitizeHtml);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

var extendedAllowedAttributes = (0, _lodash.merge)({}, _sanitizeHtml2.default.defaults.allowedAttributes, {
  '*': ['class', 'style']
});

var extendedAllowedTags = _sanitizeHtml2.default.defaults.allowedTags.concat(['span', 's', 'u']);

exports.default = (0, _lodash.partialRight)(_sanitizeHtml2.default, {
  allowedAttributes: extendedAllowedAttributes,
  allowedTags: extendedAllowedTags
});