'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = RichTextView;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _sanitize = require('./sanitize');

var _sanitize2 = _interopRequireDefault(_sanitize);

var _styles = require('./styles.css');

var _styles2 = _interopRequireDefault(_styles);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

/* eslint react/no-danger: 1 */

var Quill = void 0;
if (typeof document !== 'undefined') {
  Quill = require('react-quill');
}

function RichTextView(_ref) {
  var _ref$value = _ref.value,
      value = _ref$value === undefined ? '' : _ref$value;

  return _react2.default.createElement(Quill, {
    theme: 'snow',
    modules: { toolbar: false },
    value: (0, _sanitize2.default)(value),
    readOnly: true,
    className: _styles2.default.pre
  });
}

RichTextView.displayName = 'RichTextView';

RichTextView.propTypes = {
  details: _propTypes2.default.object.isRequired,
  value: _propTypes2.default.string.isRequired
};