/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import PropTypes from 'prop-types'

import { KeyedList } from '@kuali/formbot'

export default function CheckboxesConfig ({ onChange, value }) {
  return (
    <div>
      <h3>Options</h3>
      <KeyedList
        onChange={options => onChange({ ...value, options })}
        value={value.options || []}
      />
    </div>
  )
}

CheckboxesConfig.displayName = 'CheckboxesConfig'

CheckboxesConfig.propTypes = {
  onChange: PropTypes.func.isRequired,
  value: PropTypes.shape({
    options: PropTypes.arrayOf(
      PropTypes.shape({
        key: PropTypes.string,
        lbl: PropTypes.string
      })
    )
  }).isRequired
}
