/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import PropTypes from 'prop-types'

export default function DateView ({ value }) {
  if (!value) return <div />
  const opts = { month: 'long', day: 'numeric', year: 'numeric' }
  let date = new Date(value).toLocaleString('en-US', opts)
  if (date === 'Invalid Date') date = ''
  return <div>{date}</div>
}

DateView.displayName = 'DateView'

DateView.propTypes = {
  value: PropTypes.string
}
