/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { filter } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import { SelectField } from '@kuali/kuali-ui'

export default function DropdownEdit ({ details, formKey, onChange, value }) {
  const options = filter(details.options, 'key')
  return (
    <SelectField
      id={formKey}
      onChange={val => onChange(val)}
      fullWidth
      value={value}
      menuItems={[{ key: '', lbl: '- - -' }, ...options]}
      itemLabel='lbl'
      itemValue='key'
    />
  )
}

DropdownEdit.displayName = 'DropdownEdit'

DropdownEdit.propTypes = {
  details: PropTypes.shape({
    options: PropTypes.arrayOf(
      PropTypes.shape({
        key: PropTypes.string,
        lbl: PropTypes.string
      })
    )
  }).isRequired,
  formKey: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.string.isRequired
}
