/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { flatten, map } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import { SelectField } from '@kuali/kuali-ui'

export default function createDropdownEdit (options, hasMultiple) {
  function LocationEdit ({ formKey, onChange, value }) {
    const children = hasMultiple ? flatten(map(options, 'options')) : options
    return (
      <SelectField
        id={formKey}
        onChange={val => onChange(val)}
        value={value}
        menuItems={[{ key: '', lbl: '- - -' }, ...children]}
        itemLabel='lbl'
        itemValue='key'
      />
    )
  }
  LocationEdit.displayName = 'LocationEdit'
  LocationEdit.propTypes = {
    details: PropTypes.object.isRequired,
    formKey: PropTypes.string.isRequired,
    id: PropTypes.string.isRequired,
    onChange: PropTypes.func.isRequired,
    value: PropTypes.string.isRequired
  }
  return LocationEdit
}
