/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { flatten, map } from 'lodash'

import { countries, languages, states, provinces } from './data'
import edit from './edit'
import progressiveDisclosure from './progressive-disclosure'
import validateShape from './validations'
import view from './view'

function buildGadget (lbl, _options, hasMultiple) {
  const options = hasMultiple ? flatten(map(_options, 'options')) : _options
  return {
    view: view(options),
    edit: edit(_options, hasMultiple),

    validateShape: validateShape(options),

    progressiveDisclosure: progressiveDisclosure(options),

    defaultValue: '',

    sampleValue: '',

    meta: {
      lbl: `${lbl} Drop Down`,
      icon: 'extension',
      category: 'Elements',
      sizes: ['small', 'medium', 'large', 'xlarge']
    }
  }
}

export const CountryDropdown = buildGadget('Country', countries)
export const LanguagesDropdown = buildGadget('Language', languages)
export const StateDropdown = buildGadget(
  'State/Province',
  [
    { lbl: 'States', options: states },
    { lbl: 'Provinces', options: provinces }
  ],
  true
)
