/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { SelectField } from '@kuali/kuali-ui'

export default function createProgDisc (options) {
  function check (data, config) {
    switch (config.type) {
      case 'isSelected':
        return data === config.value
      case 'isNotSelected':
        return data !== config.value
      default:
        return true
    }
  }

  function configIsValid (configData) {
    return configData.type && configData.value
  }

  class component extends Component {
    static displayName = 'ProgressiveDisclosure'

    static propTypes = {
      details: PropTypes.object.isRequired,
      onChange: PropTypes.func.isRequired,
      value: PropTypes.object.isRequired,
      formKey: PropTypes.string.isRequired
    }

    link (key) {
      const { value, onChange } = this.props
      return {
        value: value[key] || '',
        requestChange: val => onChange({ ...value, [key]: val })
      }
    }

    render () {
      const { value, onChange, formKey } = this.props
      return (
        <div style={{ display: 'flex', flex: 2, width: 0 }}>
          <SelectField
            id={formKey}
            onChange={type => onChange({ ...value, type })}
            style={{ flex: 1, marginRight: 10 }}
            value={value.type || ''}
            menuItems={[
              { value: '', label: '- - -' },
              { value: 'isSelected', label: 'is' },
              { value: 'isNotSelected', label: 'is not' }
            ]}
          />
          <SelectField
            id={formKey}
            onChange={newVal => onChange({ ...value, value: newVal })}
            style={{ flex: 1 }}
            value={value.value || ''}
            menuItems={[{ key: '', lbl: '- - -' }, ...options]}
            itemLabel='lbl'
            itemValue='key'
          />
        </div>
      )
    }
  }

  return { check, component, configIsValid }
}
