/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { find } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'

export default function createDropdownView (options) {
  function LocationView ({ value }) {
    const option = find(options, { key: value }) || {}
    return <div>{option.lbl}</div>
  }
  LocationView.displayName = 'LocationView'
  LocationView.propTypes = {
    details: PropTypes.object.isRequired,
    value: PropTypes.string.isRequired
  }
  return LocationView
}
