/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import PropTypes from 'prop-types'
import { TextField, Label, Form, FieldGroup } from '@kuali/kuali-ui'
import { FieldCell } from '@kuali/kuali-ui/lib/forms'

export default function NumberConfig ({ onChange, value, context }) {
  console.log({ context })
  return (
    <div>
      <h3>Settings</h3>
      <Form showGrid>
        <FieldGroup>
          <FieldCell>
            <Label htmlFor='placeholder'>Placeholder</Label>
            <TextField
              type='text'
              onChange={val => onChange({ ...value, placeholder: val })}
              value={value.placeholder}
            />
          </FieldCell>
        </FieldGroup>
      </Form>
    </div>
  )
}

NumberConfig.displayName = 'NumberConfig'

NumberConfig.propTypes = {
  onChange: PropTypes.func.isRequired,
  value: PropTypes.shape({
    placeholder: PropTypes.string
  }).isRequired
}
