/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import PropTypes from 'prop-types'
import { SelectField } from '@kuali/kuali-ui'
import TextField from 'react-md/lib/TextFields'

import styles from './style.css'

export function check (data, config) {
  switch (config.type) {
    case 'equalTo':
      return data && data === config.value
    case 'greaterThan':
      return data && data > config.value
    case 'lessThan':
      return data && data < config.value
    case 'greaterThanOrEqualTo':
      return data && data >= config.value
    case 'lessThanOrEqualTo':
      return data && data <= config.value
    case 'notEqualTo':
      return data && data !== config.value
    default:
      return true
  }
}

export function configIsValid (configData) {
  return configData.type && configData.value
}

export function component ({ id, onChange, value }) {
  return (
    <div className={styles.progDisc}>
      <SelectField
        id={id}
        className={styles.select}
        onChange={type => onChange({ ...value, type })}
        value={value.type || ''}
        menuItems={[
          { value: '', label: '- - -' },
          { value: 'equalTo', label: 'is Equal to' },
          { value: 'notEqualTo', label: 'is Not Equal to' },
          { value: 'greaterThan', label: 'is Greater than' },
          { value: 'lessThan', label: 'is Less than' },
          {
            value: 'greaterThanOrEqualTo',
            label: 'is Greater than or Equal to'
          },
          { value: 'lessThanOrEqualTo', label: 'is Less than or Equal to' }
        ]}
      />
      <TextField
        type='number'
        onChange={val => onChange({ ...value, value: val })}
        style={{ flex: 1 }}
        value={value.value || ''}
      />
    </div>
  )
}

component.displayName = 'ProgressiveDisclosure'

component.propTypes = {
  id: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.shape({
    value: PropTypes.string,
    type: PropTypes.string
  }).isRequired
}
