/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

/* eslint react/no-danger: 1 */

import React from 'react'
import PropTypes from 'prop-types'

import sanitize from './sanitize'
import styles from './styles.css'

let Quill
if (typeof document !== 'undefined') {
  Quill = require('react-quill')
}

export default function RichTextView ({ value = '' }) {
  return (
    <Quill
      theme='snow'
      modules={{ toolbar: false }}
      value={sanitize(value)}
      readOnly
      className={styles.pre}
    />
  )
}

RichTextView.displayName = 'RichTextView'

RichTextView.propTypes = {
  details: PropTypes.object.isRequired,
  value: PropTypes.string.isRequired
}
