/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { get } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import TextField from 'react-md/lib/TextFields'

import styles from './style.css'

export default function TextareaEdit ({ id, details, onChange, value, error }) {
  const placeholder = get(details, 'placeholder', '')
  return (
    <div className={styles.edit}>
      <TextField
        id={id}
        error={!!error}
        errorText={error}
        onChange={val => onChange(val)}
        placeholder={placeholder}
        maxRows={0}
        rows={2}
        value={value}
      />
    </div>
  )
}

TextareaEdit.displayName = 'TextareaEdit'

TextareaEdit.propTypes = {
  id: PropTypes.string.isRequired,
  details: PropTypes.shape({
    placeholder: PropTypes.string
  }).isRequired,
  error: PropTypes.string,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.string.isRequired
}
