'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customGadgetRenderer = customGadgetRenderer;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _viewEdit = require('./view-edit.css');

var _viewEdit2 = _interopRequireDefault(_viewEdit);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function customGadgetRenderer(Formbot, mode, template, options) {
  var children = options.children,
      shouldShow = options.shouldShow,
      onChange = options.onChange,
      value = options.value;

  if (!shouldShow) return null;
  var gadgetDef = Formbot.getGadget(template.type);
  var Gadget = gadgetDef[mode];
  var gadgetChildren = _react2.default.Children.map(children, function (c) {
    return _react2.default.createElement(
      'div',
      null,
      c
    );
  });
  var props = {
    context: options.context,
    id: template.id,
    value: value,
    onChange: onChange,
    template: template
  };
  var decorators = Formbot.getDecorators({ type: template.type, mode: mode });
  var createComponent = function createComponent(_props) {
    var parts = decorators.length ? Formbot.decorate(decorators, { gadgetChildren: gadgetChildren }, _props, gadgetDef) : { gadgetChildren: gadgetChildren };
    return _react2.default.createElement(
      'div',
      { key: template.id, className: _viewEdit2.default.TEST },
      _react2.default.createElement(
        Gadget,
        { value: value, onChange: onChange, template: template },
        parts.gadgetChildren
      )
    );
  };
  var component = createComponent(props);
  return decorators.length ? Formbot.decorate(decorators, { component: component }, props, gadgetDef, createComponent).component : component;
}