/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import cx from 'classnames'
import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { DropTarget } from 'react-dnd'

import styles from './view-edit.css'

class InitialDropZone extends Component {
  static displayName = 'InitialDropZone'

  static propTypes = {
    connectDropTarget: PropTypes.any.isRequired,
    isOver: PropTypes.any.isRequired
  }

  render () {
    const { connectDropTarget, isOver } = this.props
    if (!isOver) {
      return connectDropTarget(
        <div className={styles.helpText}>
          <div>
            <span>{'Drag and Drop '}</span>
            <span className={styles.bold}>{'Gadgets'}</span>
            <span>{' to create '}</span>
            <span className={styles.bold}>{'Multiple Rows'}</span>
          </div>
        </div>
      )
    }
    return connectDropTarget(
      <div className={cx(styles.helpText, styles.hovered)}>Drop Zone</div>
    )
  }
}

const rowTarget = {
  drop (props, monitor) {
    const item = monitor.getItem()
    props.onChange(item)
  }
}

function collect (connect, monitor) {
  return {
    connectDropTarget: connect.dropTarget(),
    isOver: monitor.isOver()
  }
}

export default DropTarget('Gadget', rowTarget, collect)(InitialDropZone)
