/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import TextField from 'react-md/lib/TextFields'

export default class ChildConfig extends Component {
  static displayName = 'ChildConfig'

  static propTypes = {
    onChange: PropTypes.func.isRequired,
    value: PropTypes.object.isRequired
  }

  link (key) {
    const { value, onChange } = this.props
    return {
      value: value[key],
      requestChange: val => onChange({ ...value, [key]: val })
    }
  }

  render () {
    const { onChange, value } = this.props
    return (
      <div>
        <p>
          {
            'This number represents how much space the element takes compared to '
          }
          {
            "it's siblings. For example: 2 would mean that this element takes up "
          }
          {"twice the space of others in it's row. The default is 1."}
        </p>
        <TextField
          label='Flex'
          onChange={val => onChange({ ...value, flex: val })}
          type='number'
          value={value.flex}
        />
      </div>
    )
  }
}
