/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import Paper from 'react-md/lib/Papers'

import styles from './view-edit.css'

export function customGadgetRenderer (Formbot, mode, template, options) {
  const { children, shouldShow, context } = options
  if (!shouldShow) return null
  const gadgetDef = Formbot.getGadget(template.type)
  const label = <div className={styles.title}>{template.label}</div>
  const decorators = Formbot.getDecorators({ type: template.type, mode })
  const props = { children, context, template }
  const createComponent = _props => {
    const gadget = (
      <div style={{ padding: 15, display: 'flex', flexWrap: 'wrap' }}>
        {_props.children}
      </div>
    )
    const parts = decorators.length
      ? Formbot.decorate(decorators, { label, gadget }, _props, gadgetDef)
      : { label, gadget }
    const toRender = template.root ? (
      <div>{parts.gadget}</div>
    ) : (
      <div className={styles[`size-${template.fieldSize || 'large'}`]}>
        <Paper className={styles.wrapper} key={template.id}>
          {parts.label}
          {parts.gadget}
        </Paper>
      </div>
    )

    return toRender
  }
  const component = createComponent(props)
  return decorators.length
    ? Formbot.decorate(
        decorators,
        { component },
        props,
        gadgetDef,
        createComponent
      ).component
    : component
}
