'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _buttons = require('../buttons');

var _icons = require('../icons');

var _icons2 = _interopRequireDefault(_icons);

var _reactTransitionGroup = require('react-transition-group');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var kualiAlertTypeInfo = {
  info: {
    headerLabel: 'Info',
    iconName: 'info',
    iconColor: 'info'
  },
  success: {
    headerLabel: 'Success',
    iconName: 'check_circle',
    iconColor: 'success'
  },
  warning: {
    headerLabel: 'Warning',
    iconName: 'warning',
    iconColor: 'warning'
  },
  error: {
    headerLabel: 'Error',
    iconName: 'cancel',
    iconColor: 'error'
  }
};

function generateAlertHeader(title, type, useHeaderLabel) {
  if (useHeaderLabel && title) {
    return kualiAlertTypeInfo[type].headerLabel + ' - ' + title;
  }
  return useHeaderLabel ? kualiAlertTypeInfo[type].headerLabel : title;
}

var Alert = function (_Component) {
  _inherits(Alert, _Component);

  function Alert(props) {
    _classCallCheck(this, Alert);

    var _this = _possibleConstructorReturn(this, (Alert.__proto__ || Object.getPrototypeOf(Alert)).call(this, props));

    _this.closeAlert = function () {
      _this.setState({ isOpen: false });
      if (_this.props.onClose) {
        _this.props.onClose();
      }
    };

    _this.state = { isOpen: true };
    return _this;
  }

  _createClass(Alert, [{
    key: 'autoHide',
    value: function autoHide(visibleFor) {
      var _this2 = this;

      setTimeout(function () {
        _this2.closeAlert();
      }, visibleFor);
    }
  }, {
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (this.props.autoHide) {
        this.autoHide(this.props.visibleFor);
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          type = _props.type,
          title = _props.title,
          useHeaderLabel = _props.useHeaderLabel,
          message = _props.message;

      return _react2.default.createElement(
        _reactTransitionGroup.CSSTransition,
        {
          classNames: 'kuali-alert',
          timeout: {
            appear: 650,
            exit: 600
          },
          appear: true,
          mountOnEnter: true,
          unmountOnExit: true,
          'in': this.state.isOpen
        },
        _react2.default.createElement(
          'div',
          {
            className: (0, _classnames2.default)('kuali-alert--container', 'kuali-alert--type---' + type)
          },
          _react2.default.createElement(
            'div',
            { className: 'kuali-alert--icon---box' },
            _react2.default.createElement(_icons2.default, {
              name: kualiAlertTypeInfo[type]['iconName'],
              variant: kualiAlertTypeInfo[type]['iconColor']
            })
          ),
          _react2.default.createElement(
            'div',
            { className: 'kuali-alert--data---box' },
            _react2.default.createElement(
              'h1',
              null,
              generateAlertHeader(title, type, useHeaderLabel)
            ),
            _react2.default.createElement(
              'p',
              null,
              message
            )
          ),
          _react2.default.createElement(
            'div',
            { className: 'kuali-alert--header---close' },
            _react2.default.createElement(
              _buttons.IconButton,
              { onClick: this.closeAlert },
              _react2.default.createElement(_icons2.default, { name: 'clear' })
            )
          )
        )
      );
    }
  }]);

  return Alert;
}(_react.Component);

Alert.TYPES = {
  INFO: 'info',
  SUCCESS: 'success',
  WARNING: 'warning',
  ERROR: 'error'
};
Alert.defaultProps = {
  autoHide: false,
  useHeaderLabel: true,
  type: Alert.TYPES.INFO,
  visibleFor: 5000
};
Alert.propTypes = {
  autoHide: _propTypes2.default.bool,
  message: _propTypes2.default.string.isRequired,
  onClose: _propTypes2.default.func,
  title: _propTypes2.default.string,
  type: _propTypes2.default.oneOf(['info', 'success', 'warning', 'error']),
  useHeaderLabel: _propTypes2.default.bool,
  visibleFor: _propTypes2.default.number
};
exports.default = Alert;