'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.supportedVariants = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _Inks = require('react-md/lib/Inks');

var _Inks2 = _interopRequireDefault(_Inks);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _proptypes = require('../utils/proptypes');

var _icons = require('../icons');

var _icons2 = _interopRequireDefault(_icons);

var _tooltips = require('../tooltips');

var _tooltips2 = _interopRequireDefault(_tooltips);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var supportedVariants = exports.supportedVariants = ['default',

// all purpose
'clear', 'plain',

// brand colors
'primary',

// actions
'error', 'info', 'success', 'warning',

// brand colors
'wintergreen', 'frost', 'glacier', 'mint', 'popsicle', 'magma', 'chili', 'flare', 'torch'];

var unsupportedProps = ['forceIconSize', 'forceIconFontSize', 'floating', 'fixed', 'fixedPosition', 'mini', 'primary', 'secondary', 'type'].reduce(function (acc, cur) {
  return _extends({}, acc, _defineProperty({}, cur, _proptypes.unsupported));
}, {});

var Button = (0, _Inks2.default)(_class = (0, _tooltips2.default)(_class = function (_PureComponent) {
  _inherits(Button, _PureComponent);

  function Button() {
    _classCallCheck(this, Button);

    return _possibleConstructorReturn(this, (Button.__proto__ || Object.getPrototypeOf(Button)).apply(this, arguments));
  }

  _createClass(Button, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          block = _props.block,
          className = _props.className,
          Component = _props.component,
          flat = _props.flat,
          label = _props.label,
          icon = _props.icon,
          iconBefore = _props.iconBefore,
          ink = _props.ink,
          raised = _props.raised,
          size = _props.size,
          tooltip = _props.tooltip,
          variant = _props.variant,
          rest = _objectWithoutProperties(_props, ['block', 'className', 'component', 'flat', 'label', 'icon', 'iconBefore', 'ink', 'raised', 'size', 'tooltip', 'variant']);

      delete rest.children;
      delete rest.iconClassName;
      delete rest.tooltipLabel;
      delete rest.tooltipDelay;
      delete rest.tooltipPosition;

      var classes = (0, _classnames2.default)('kuali-button', 'kuali-button--' + variant, 'kuali-button--size__' + size, {
        'kuali-button--block': block,
        'kuali-button--flat': flat,
        'kuali-button--icon': icon,
        'kuali-button--raised': raised
      }, className);

      return _react2.default.createElement(
        Component,
        _extends({ className: classes }, rest),
        ink,
        tooltip,
        iconBefore && this.icon,
        label && _react2.default.createElement(
          'span',
          { className: 'kuali-button__label' },
          label
        ),
        !iconBefore && this.icon
      );
    }
  }, {
    key: 'icon',
    get: function get() {
      var _props2 = this.props,
          stringOrIcon = _props2.children,
          iconClassName = _props2.iconClassName;


      if (!stringOrIcon) return null;

      var isString = typeof stringOrIcon === 'string';
      var ToRender = isString ? _react2.default.createElement(_icons2.default, { name: stringOrIcon }) : stringOrIcon;

      return _react2.default.cloneElement(ToRender, {
        className: (0, _classnames2.default)('kuali-button__icon', ToRender.props.className, iconClassName)
      });
    }
  }]);

  return Button;
}(_react.PureComponent)) || _class) || _class;

Button.defaultProps = {
  block: false,
  children: null,
  component: 'button',
  icon: false,
  iconBefore: true,
  size: 'default',
  variant: 'default'
};
Button.propTypes = _extends({}, unsupportedProps, {
  block: _propTypes2.default.bool.isRequired,
  children: _propTypes2.default.node,
  className: _propTypes2.default.string,
  component: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]),
  flat: _propTypes2.default.bool,
  label: _propTypes2.default.node,
  icon: _propTypes2.default.bool,
  iconBefore: _propTypes2.default.bool.isRequired,
  iconClassName: _propTypes2.default.string,
  ink: _propTypes2.default.node,
  raised: _propTypes2.default.bool,
  size: _propTypes2.default.oneOf(['default', 'small']).isRequired,
  variant: _propTypes2.default.oneOf(supportedVariants).isRequired
});
exports.default = Button;