'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EASE_OUT_QUAD = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _cmColumn = require('./cm-column');

var _cmColumn2 = _interopRequireDefault(_cmColumn);

var _cmColumnHelp = require('./cm-column-help');

var _cmColumnHelp2 = _interopRequireDefault(_cmColumnHelp);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

/* eslint-disable no-return-assign */

var COL_WIDTH = 180;
var EASE_OUT_QUAD = exports.EASE_OUT_QUAD = function EASE_OUT_QUAD(t) {
  return t * (2 - t);
};

var ColumnMenu = function (_Component) {
  _inherits(ColumnMenu, _Component);

  function ColumnMenu(props) {
    _classCallCheck(this, ColumnMenu);

    var _this = _possibleConstructorReturn(this, (ColumnMenu.__proto__ || Object.getPrototypeOf(ColumnMenu)).call(this, props));

    _this.state = {
      columns: []
    };

    _this.match = undefined;
    _this.$frame = undefined;

    _this.addColumn = _this.addColumn.bind(_this);
    _this.colSelect = _this.colSelect.bind(_this);
    return _this;
  }

  _createClass(ColumnMenu, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      this.initMatcher(this.props.match);
      this.initColumns(this.props);
    }

    /**
     * TODO: Possible bug. The isEqual call in this method will detect if the data
     * object is replaced, but not if it is updated
     * @param {*} nextProps
     */

  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      this.initMatcher(nextProps.match);
      if (!(0, _lodash.isEqual)(this.props, nextProps)) {
        this.initColumns(nextProps);
      }
    }

    /**
     * TODO: Possible bug. The isEqual call in this method will detect if the data
     * object is replaced, but not if it is updated
     * @param {*} nextProps
     * @param {*} nextState
     */

  }, {
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps, nextState) {
      return !((0, _lodash.isEqual)(this.props, nextProps) && (0, _lodash.isEqual)(this.state, nextState));
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      this.scroll();
    }
  }, {
    key: 'scroll',
    value: function scroll() {
      var target = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.$frame;
      var columns = this.state.columns;

      var to = Math.max(0, columns.length * COL_WIDTH - COL_WIDTH);
      var from = target.scrollLeft;
      target.scrollTop = 0;

      if (Math.abs(from - to) > 3) {
        setTimeout(this.scrollAnimation.bind(this, target, 'scrollLeft', from, to, 800, EASE_OUT_QUAD), 300);
      }
    }
  }, {
    key: 'scrollAnimation',
    value: function scrollAnimation(target, attr, from, to, time, fn, callback) {
      var onFrame = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : window.requestAnimationFrame;

      var dist = to - from;
      var start = null;

      function step(ts) {
        if (!start) {
          start = ts;
        }
        var progress = (ts - start) / time;
        var dest = from + fn(progress) * dist;
        target[attr] = dest;
        if (progress < 1) {
          onFrame(step);
        } else {
          if (callback) {
            callback();
          }
        }
      }
      onFrame(step);
    }
  }, {
    key: 'initColumns',
    value: function initColumns(props) {
      var column = props.column,
          data = props.data,
          help = props.help,
          match = props.match;

      if (!column && !data) {
        throw new Error('ColumnMenu ERROR: no column or data');
      }

      var columns = [];
      if (help) {
        var scroll = this.scroll.bind(this);
        columns.push(_react2.default.createElement(_cmColumnHelp2.default, { key: 'help', help: help, scroll: scroll }));
      }
      var Col = column || _cmColumn2.default;
      columns.push(_react2.default.createElement(Col, {
        key: 'c' + columns.length,
        data: data,
        match: match,
        onSelect: this.colSelect,
        addColumn: this.addColumn.bind(this, columns.length)
      }));

      this.setState({ columns: columns });
    }

    // This should be moved to the column?

  }, {
    key: 'initMatcher',
    value: function initMatcher(match) {
      if ((0, _lodash.isFunction)(match)) {
        this.match = match;
      } else if ((0, _lodash.isArray)(match)) {
        this.match = this.matchArrayTypes.bind(this, match);
      } else if ((0, _lodash.isObject)(match)) {
        this.match = this.matchObjectTypes.bind(this, match);
      } else if ((0, _lodash.isString)(match)) {
        this.match = this.matchStringTypes.bind(this, match);
      } else {
        throw new Error('Unexpected match type');
      }
    }

    // This should be moved to the column?

  }, {
    key: 'matchArrayTypes',
    value: function matchArrayTypes(obj, value) {
      if ((0, _lodash.isObject)(value)) {
        value = value.type || value.toString();
      }
      return obj.includes(value);
    }

    // This should be moved to the column?

  }, {
    key: 'matchObjectTypes',
    value: function matchObjectTypes(obj, value) {
      try {
        return value instanceof obj;
      } catch (err) {
        return value instanceof obj.constructor;
      }
    }

    // This should be moved to the column?

  }, {
    key: 'matchStringTypes',
    value: function matchStringTypes(str, value) {
      if ((0, _lodash.isObject)(value)) {
        value = value.type || value.toString();
      }
      return str === value;
    }
  }, {
    key: 'colSelect',
    value: function colSelect(value) {
      if (this.match(value)) {
        this.props.onSelect(value);
        return true;
      }
      return false;
    }

    /* eslint-disable indent */

  }, {
    key: 'addColumn',
    value: function addColumn(index, Col, key, value) {
      var trunc = this.state.columns.slice(0, index + 1);
      var columns = [].concat(_toConsumableArray(trunc), [_react2.default.createElement(Col, {
        key: 'c' + trunc.length,
        data: value,
        match: this.props.match,
        onSelect: this.colSelect,
        addColumn: this.addColumn.bind(this, trunc.length)
      })]);
      this.setState({ columns: columns });
    }
    /* eslint-enable indent */

  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var columns = this.state.columns;

      var width = COL_WIDTH * columns.length;

      return _react2.default.createElement(
        'div',
        { className: _style2.default.frame, ref: function ref($el) {
            return _this2.$frame = $el;
          } },
        _react2.default.createElement('div', {
          className: _style2.default.container,
          style: { width: width + 'px' },
          children: columns
        })
      );
    }
  }]);

  return ColumnMenu;
}(_react.Component);

ColumnMenu.propTypes = {
  column: _propTypes2.default.func,
  data: _propTypes2.default.oneOfType([_propTypes2.default.array, _propTypes2.default.object, _propTypes2.default.func]),
  help: _propTypes2.default.string,
  match: _propTypes2.default.oneOfType([_propTypes2.default.array, _propTypes2.default.func, _propTypes2.default.object, _propTypes2.default.string]).isRequired,
  onSelect: _propTypes2.default.func.isRequired
};
exports.default = ColumnMenu;