'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _class; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
             * You may use and modify this code under the terms of the Kuali, Inc.
             * Pre-Release License Agreement. You may not distribute it.
             *
             * You should have received a copy of the Kuali, Inc. Pre-Release License
             * Agreement with this file. If not, please write to license@kuali.co.
             */

// eslint-disable-line module-name/kebab-case


var _isString = require('lodash/isString');

var _isString2 = _interopRequireDefault(_isString);

var _get = require('lodash/get');

var _get2 = _interopRequireDefault(_get);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _coreDecorators = require('core-decorators');

var _constants = require('../../constants');

var _datePickerButton = require('../date-picker-button');

var _datePickerButton2 = _interopRequireDefault(_datePickerButton);

var _deleteIcon = require('../delete-icon');

var _deleteIcon2 = _interopRequireDefault(_deleteIcon);

var _operation = require('../operation');

var _operation2 = _interopRequireDefault(_operation);

var _textFieldCustom = require('../text-field-custom');

var _textFieldCustom2 = _interopRequireDefault(_textFieldCustom);

var _timeField = require('../time-field');

var _timeField2 = _interopRequireDefault(_timeField);

var _selectFieldButton = require('../select-field-button');

var _selectFieldButton2 = _interopRequireDefault(_selectFieldButton);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * @param {string} fieldType
 * @param {(string[])[]} operatorMapping
 * @returns {string[]}
 */
function getOperatorsFor(fieldType, operatorMapping) {
  if (!fieldType || !operatorMapping[fieldType]) {
    return ['Please select a field'];
  }
  return operatorMapping[fieldType];
}

var Rule = (0, _coreDecorators.autobind)(_class = function (_Component) {
  _inherits(Rule, _Component);

  function Rule(props) {
    _classCallCheck(this, Rule);

    var _this = _possibleConstructorReturn(this, (Rule.__proto__ || Object.getPrototypeOf(Rule)).call(this, props));

    _this.state = {
      field: props.selectedField,
      operator: props.selectedOperator,
      value: props.value
    };
    return _this;
  }

  _createClass(Rule, [{
    key: 'deleteRule',
    value: function deleteRule() {
      this.props.onRemove(this.props.id);
    }

    /**
     * @param {string} newField
     */

  }, {
    key: 'fieldChanged',
    value: function fieldChanged(newField) {
      var field = this.props.availableFields.find(function (f) {
        return f.label === newField;
      });
      var operator = this.state.operator;

      if (operator) {
        var newPossibleOperators = getOperatorsFor(field.type, _constants.AVAILABLE_OPERATORS);
        var existingOperatorIsValid = newPossibleOperators.some(function (type) {
          return type === operator;
        });
        if (!existingOperatorIsValid) {
          this.setState({ operator: undefined });
        }
      }
      this.setState({
        field: field,
        value: undefined
      });
      this.ruleChanged(field, operator, undefined);
    }

    /**
     * @param {string} operator
     */

  }, {
    key: 'operatorChanged',
    value: function operatorChanged(operator) {
      this.setState({ operator: operator });
      var _state = this.state,
          field = _state.field,
          value = _state.value;

      if (operator === _constants.OPERATOR_TYPES.BLANK || operator === _constants.OPERATOR_TYPES.NOT_BLANK) {
        this.setState({ value: undefined });
        this.ruleChanged(field, operator, undefined);
        return;
      }
      this.ruleChanged(field, operator, value);
    }
  }, {
    key: 'ruleChanged',
    value: function ruleChanged(field, operator, value) {
      var functionOperatorKey = _constants.OPERATOR_KEYS[operator];
      var operatorFunction = _constants.OPERATOR_FUNCTIONS[field.type][functionOperatorKey];
      this.props.onRuleChanged({
        id: this.props.id,
        field: field,
        operator: operator,
        value: value,
        matchFunction: operatorFunction ? operatorFunction(field.name, value) : function () {}
      });
    }

    /**
     * @param {string} dateString
     * @param {Date} dateObject
     */

  }, {
    key: 'dateChanged',
    value: function dateChanged(dateString, dateObject) {
      this.valueChanged(dateObject.getTime());
    }
  }, {
    key: 'valueChanged',
    value: function valueChanged(value) {
      var _state2 = this.state,
          field = _state2.field,
          operator = _state2.operator;

      if (value === undefined || (0, _isString2.default)(value) && value.length === 0) {
        this.setState({ value: undefined });
        this.ruleChanged(field, operator, undefined);
      } else {
        this.setState({ value: value });
        this.ruleChanged(field, operator, value);
      }
    }
  }, {
    key: 'getValueChooser',
    value: function getValueChooser() {
      var _state3 = this.state,
          field = _state3.field,
          operator = _state3.operator,
          value = _state3.value;


      if (!field || !operator) {
        return _react2.default.createElement(_textFieldCustom2.default, {
          id: 'value' + this.props.id,
          disabled: true,
          onChange: this.valueChanged,
          className: 'filter-editor__rule-control',
          value: value || ''
        });
      }

      if (operator === _constants.OPERATOR_TYPES.BLANK || operator === _constants.OPERATOR_TYPES.NOT_BLANK) {
        return null;
      }

      switch (field.type) {
        case _constants.FIELD_TYPES.DATE:
          {
            var dateValue = value ? new Date(value) : null;
            return _react2.default.createElement(_datePickerButton2.default, {
              className: 'filter-editor__rule-control',
              id: 'datepicker' + field.label,
              onChange: this.dateChanged,
              value: dateValue
            });
          }
        case _constants.FIELD_TYPES.ENUM:
          return _react2.default.createElement(_selectFieldButton2.default, {
            className: 'filter-editor__rule-control',
            id: 'valueselector' + field.label,
            menuItems: field.values,
            onChange: this.valueChanged,
            value: value
          });
        case _constants.FIELD_TYPES.NUMBER:
          return _react2.default.createElement(_textFieldCustom2.default, {
            id: 'value' + field.label,
            className: 'filter-editor__rule-control',
            onChange: this.valueChanged,
            value: value || '',
            type: 'number'
          });
        case _constants.FIELD_TYPES.TEXT:
          return _react2.default.createElement(_textFieldCustom2.default, {
            id: 'value' + field.label,
            className: 'filter-editor__rule-control',
            onChange: this.valueChanged,
            value: value || ''
          });
        case _constants.FIELD_TYPES.TIME:
          return _react2.default.createElement(_timeField2.default, {
            id: 'timeValue' + field.label,
            className: 'filter-editor__rule-control',
            onChange: this.valueChanged,
            value: value || ''
          });
        default:
          throw Error('Invalid field type');
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          rowIndex = _props.rowIndex,
          operationType = _props.operationType,
          availableFields = _props.availableFields;


      return _react2.default.createElement(
        'li',
        { className: 'filter-editor__rule' },
        _react2.default.createElement(_deleteIcon2.default, { onDelete: this.deleteRule }),
        _react2.default.createElement(
          'div',
          { className: 'filter-editor__rule-content' },
          _react2.default.createElement(_operation2.default, {
            rowIndex: rowIndex,
            onChange: this.props.onOperationChanged,
            value: operationType
          }),
          _react2.default.createElement(_selectFieldButton2.default, {
            id: 'field selector',
            className: 'filter-editor__rule-control',
            menuItems: availableFields.map(function (field) {
              return field.label;
            }),
            onChange: this.fieldChanged,
            value: (0, _get2.default)(this, 'state.field.label')
          }),
          _react2.default.createElement(_selectFieldButton2.default, {
            id: 'operator selector',
            className: 'filter-editor__rule-control',
            menuItems: getOperatorsFor((0, _get2.default)(this, 'state.field.type'), _constants.AVAILABLE_OPERATORS),
            value: (0, _get2.default)(this, 'state.operator'),
            onChange: this.operatorChanged
          }),
          this.getValueChooser()
        )
      );
    }
  }]);

  return Rule;
}(_react.Component)) || _class;

Rule.propTypes = {
  availableFields: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    label: _propTypes2.default.string.isRequired,
    name: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]).isRequired,
    type: _propTypes2.default.oneOf([_constants.FIELD_TYPES.DATE, _constants.FIELD_TYPES.ENUM, _constants.FIELD_TYPES.NUMBER, _constants.FIELD_TYPES.TEXT, _constants.FIELD_TYPES.TIME]).isRequired,
    values: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      value: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string]).isRequired,
      label: _propTypes2.default.string.isRequired
    }))
  })).isRequired,
  id: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number]).isRequired,
  onRuleChanged: _propTypes2.default.func.isRequired,
  onOperationChanged: _propTypes2.default.func.isRequired,
  onRemove: _propTypes2.default.func.isRequired,
  operationType: _propTypes2.default.oneOf([_constants.OPERATION_TYPES.AND, _constants.OPERATION_TYPES.OR]),
  rowIndex: _propTypes2.default.number.isRequired,
  selectedField: _propTypes2.default.shape({
    label: _propTypes2.default.string.isRequired,
    name: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.func]).isRequired,
    type: _propTypes2.default.oneOf([_constants.FIELD_TYPES.DATE, _constants.FIELD_TYPES.ENUM, _constants.FIELD_TYPES.NUMBER, _constants.FIELD_TYPES.TEXT, _constants.FIELD_TYPES.TIME]).isRequired,
    values: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      value: _propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string]).isRequired,
      label: _propTypes2.default.string.isRequired
    }))
  }),
  selectedOperator: _propTypes2.default.oneOf(Object.keys(_constants.OPERATOR_TYPES).map(function (key) {
    return _constants.OPERATOR_TYPES[key];
  })),
  value: _propTypes2.default.any
};
Rule.defaultProps = {
  operationType: _constants.OPERATION_TYPES.AND,
  selectedField: undefined,
  selectedOperator: undefined,
  value: undefined
};
exports.default = Rule;